/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostIt {
    private final String id;
    private final List<String> text;
    private Dimension2D minimunDimension;

    public PostIt(String string, List<String> list) {
        this.id = string;
        this.text = list;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getText() {
        return Collections.unmodifiableList(this.text);
    }

    public Dimension2D getMinimunDimension() {
        return this.minimunDimension;
    }

    public void setMinimunDimension(Dimension2D dimension2D) {
        this.minimunDimension = dimension2D;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        double d = this.getComponent().getPreferredWidth(stringBounder);
        double d2 = this.getComponent().getPreferredHeight(stringBounder);
        if (this.minimunDimension != null && d < this.minimunDimension.getWidth()) {
            d = this.minimunDimension.getWidth();
        }
        if (this.minimunDimension != null && d2 < this.minimunDimension.getHeight()) {
            d2 = this.minimunDimension.getHeight();
        }
        return new Dimension2DDouble(d, d2);
    }

    public void drawU(UGraphic uGraphic) {
        Component component = this.getComponent();
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        component.drawU(uGraphic, dimension2D, new SimpleContext2D(false));
    }

    private Component getComponent() {
        HtmlColor htmlColor = HtmlColor.getColorIfValid("#FBFB77");
        HtmlColor htmlColor2 = HtmlColor.getColorIfValid("#A80036");
        SkinParam skinParam = new SkinParam();
        UFont uFont = skinParam.getFont(FontParam.NOTE, null);
        ComponentRoseNote componentRoseNote = new ComponentRoseNote(htmlColor, htmlColor2, HtmlColor.BLACK, uFont, this.text);
        return componentRoseNote;
    }
}

