/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisibilityModifier {
    PRIVATE_FIELD(ColorParam.iconPrivate, null),
    PROTECTED_FIELD(ColorParam.iconProtected, null),
    PACKAGE_PRIVATE_FIELD(ColorParam.iconPackage, null),
    PUBLIC_FIELD(ColorParam.iconPublic, null),
    PRIVATE_METHOD(ColorParam.iconPrivate, ColorParam.iconPrivateBackground),
    PROTECTED_METHOD(ColorParam.iconProtected, ColorParam.iconProtectedBackground),
    PACKAGE_PRIVATE_METHOD(ColorParam.iconPackage, ColorParam.iconPackageBackground),
    PUBLIC_METHOD(ColorParam.iconPublic, ColorParam.iconPublicBackground);

    private final ColorParam foregroundParam;
    private final ColorParam backgroundParam;

    private VisibilityModifier(ColorParam colorParam, ColorParam colorParam2) {
        this.foregroundParam = colorParam;
        this.backgroundParam = colorParam2;
    }

    public UDrawable getUDrawable(final int n, final HtmlColor htmlColor, final HtmlColor htmlColor2) {
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                VisibilityModifier.this.drawInternal(uGraphic, n, htmlColor, htmlColor2);
            }
        };
    }

    public TextBlock getUBlock(final int n, final HtmlColor htmlColor, final HtmlColor htmlColor2) {
        return new TextBlock(){

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(n + 1, n + 1);
            }

            public void drawTOBEREMOVED(ColorMapper colorMapper, Graphics2D graphics2D, double d, double d2) {
                throw new UnsupportedOperationException();
            }

            public void drawU(UGraphic uGraphic, double d, double d2) {
                double d3 = uGraphic.getTranslateX();
                double d4 = uGraphic.getTranslateY();
                uGraphic.translate(d, d2);
                VisibilityModifier.this.drawInternal(uGraphic, n, htmlColor, htmlColor2);
                uGraphic.setTranslate(d3, d4);
            }
        };
    }

    private void drawInternal(UGraphic uGraphic, int n, HtmlColor htmlColor, HtmlColor htmlColor2) {
        uGraphic.getParam().setBackcolor(htmlColor2);
        uGraphic.getParam().setColor(htmlColor);
        n = VisibilityModifier.ensureEven(n);
        switch (this) {
            case PACKAGE_PRIVATE_FIELD: {
                this.drawTriangle(uGraphic, false, n);
                break;
            }
            case PRIVATE_FIELD: {
                this.drawSquare(uGraphic, false, n);
                break;
            }
            case PROTECTED_FIELD: {
                this.drawDiamond(uGraphic, false, n);
                break;
            }
            case PUBLIC_FIELD: {
                this.drawCircle(uGraphic, false, n);
                break;
            }
            case PACKAGE_PRIVATE_METHOD: {
                this.drawTriangle(uGraphic, true, n);
                break;
            }
            case PRIVATE_METHOD: {
                this.drawSquare(uGraphic, true, n);
                break;
            }
            case PROTECTED_METHOD: {
                this.drawDiamond(uGraphic, true, n);
                break;
            }
            case PUBLIC_METHOD: {
                this.drawCircle(uGraphic, true, n);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void drawSquare(UGraphic uGraphic, boolean bl, int n) {
        uGraphic.draw(2.0, 2.0, new URectangle(n - 4, n - 4));
    }

    private void drawCircle(UGraphic uGraphic, boolean bl, int n) {
        uGraphic.draw(2.0, 2.0, new UEllipse(n - 4, n - 4));
    }

    private static int ensureEven(int n) {
        if (n % 2 == 1) {
            --n;
        }
        return n;
    }

    private void drawDiamond(UGraphic uGraphic, boolean bl, int n) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint((double)(n -= 2) / 2.0, 0.0);
        uPolygon.addPoint(n, (double)n / 2.0);
        uPolygon.addPoint((double)n / 2.0, n);
        uPolygon.addPoint(0.0, (double)n / 2.0);
        uGraphic.draw(1.0, 0.0, uPolygon);
    }

    private void drawTriangle(UGraphic uGraphic, boolean bl, int n) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint((double)(n -= 2) / 2.0, 1.0);
        uPolygon.addPoint(0.0, n - 1);
        uPolygon.addPoint(n, n - 1);
        uGraphic.draw(1.0, 0.0, uPolygon);
    }

    public static boolean isVisibilityCharacter(char c) {
        if (c == '-') {
            return true;
        }
        if (c == '#') {
            return true;
        }
        if (c == '+') {
            return true;
        }
        return c == '~';
    }

    public static VisibilityModifier getVisibilityModifier(char c, boolean bl) {
        if (bl) {
            return VisibilityModifier.getVisibilityModifierForField(c);
        }
        return VisibilityModifier.getVisibilityModifierForMethod(c);
    }

    private static VisibilityModifier getVisibilityModifierForField(char c) {
        if (c == '-') {
            return PRIVATE_FIELD;
        }
        if (c == '#') {
            return PROTECTED_FIELD;
        }
        if (c == '+') {
            return PUBLIC_FIELD;
        }
        if (c == '~') {
            return PACKAGE_PRIVATE_FIELD;
        }
        return null;
    }

    private static VisibilityModifier getVisibilityModifierForMethod(char c) {
        if (c == '-') {
            return PRIVATE_METHOD;
        }
        if (c == '#') {
            return PROTECTED_METHOD;
        }
        if (c == '+') {
            return PUBLIC_METHOD;
        }
        if (c == '~') {
            return PACKAGE_PRIVATE_METHOD;
        }
        return null;
    }

    public final ColorParam getForeground() {
        return this.foregroundParam;
    }

    public final ColorParam getBackground() {
        return this.backgroundParam;
    }
}

