/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram2.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.activitydiagram2.ActivityDiagram2;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMultilinesNoteActivity2
extends CommandMultilines<ActivityDiagram2> {
    public CommandMultilinesNoteActivity2(ActivityDiagram2 activityDiagram2) {
        super(activityDiagram2, "(?i)^note\\s+(right|left|top|bottom)$", "(?i)^end ?note$");
    }

    @Override
    public final CommandExecutionResult execute(List<String> list) {
        Link link;
        List<String> list2 = StringUtils.getSplit(this.getStartingPattern(), list.get(0).trim());
        String string = list2.get(0);
        IEntity iEntity = ((ActivityDiagram2)this.getSystem()).getLastEntityConsulted();
        if (iEntity == null) {
            return CommandExecutionResult.error("No activity defined");
        }
        List<String> list3 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
        String string2 = StringUtils.getMergedLines(list3);
        Entity entity = ((ActivityDiagram2)this.getSystem()).createEntity("GMN" + UniqueSequence.getValue(), string2, EntityType.NOTE);
        Position position = Position.valueOf(string.toUpperCase()).withRankdir(((ActivityDiagram2)this.getSystem()).getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, entity, linkType, null, 1);
        } else if (position == Position.LEFT) {
            link = new Link(entity, iEntity, linkType, null, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, entity, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(entity, iEntity, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        ((ActivityDiagram2)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

