/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.GroupPngMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramSimplifier {
    private final CucaDiagram diagram;
    private final FileFormat fileFormat;

    public CucaDiagramSimplifier(CucaDiagram cucaDiagram, List<String> list, FileFormat fileFormat) throws IOException, InterruptedException {
        boolean bl;
        this.diagram = cucaDiagram;
        this.fileFormat = fileFormat;
        do {
            bl = false;
            ArrayList<Group> arrayList = new ArrayList<Group>(cucaDiagram.getGroups());
            for (Group group : arrayList) {
                EntityType entityType;
                if (!cucaDiagram.isAutarkic(group)) continue;
                if (group.getType() == GroupType.CONCURRENT_STATE) {
                    entityType = EntityType.STATE_CONCURRENT;
                } else if (group.getType() == GroupType.STATE) {
                    entityType = EntityType.STATE;
                } else if (group.getType() == GroupType.INNER_ACTIVITY) {
                    entityType = EntityType.ACTIVITY;
                } else if (group.getType() == GroupType.CONCURRENT_ACTIVITY) {
                    entityType = EntityType.ACTIVITY_CONCURRENT;
                } else {
                    throw new IllegalStateException();
                }
                Entity entity = new Entity("#" + group.getCode(), group.getDisplay(), entityType, group.getParent(), cucaDiagram.getHides());
                if (entityType == EntityType.STATE) {
                    this.manageBackColorForState(cucaDiagram, group, entity);
                }
                for (Member member : group.getEntityCluster().getFieldsToDisplay()) {
                    entity.addField(member);
                }
                this.computeImageGroup(group, entity, list);
                cucaDiagram.overideGroup(group, entity);
                if (entity.getImageFile() != null) {
                    cucaDiagram.ensureDelete(entity.getImageFile());
                }
                for (IEntity iEntity : group.entities().values()) {
                    DrawFile drawFile = iEntity.getImageFile();
                    if (drawFile == null) continue;
                    entity.addSubImage(drawFile);
                }
                bl = true;
            }
        } while (bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeImageGroup(Group group, Entity entity, List<String> list) throws IOException, FileNotFoundException, InterruptedException {
        if (group.entities().size() == 0) {
            return;
        }
        GroupPngMaker groupPngMaker = new GroupPngMaker(this.diagram, group, this.fileFormat);
        File file = FileUtils.createTempFile("inner", ".png");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            groupPngMaker.createPng(fileOutputStream, list);
            String string = groupPngMaker.createSvg(list);
            entity.setImageFile(DrawFile.createFromFile(file, string, null));
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private void manageBackColorForState(CucaDiagram cucaDiagram, Group group, Entity entity) {
    }
}

