/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v1.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Subject;

public class AccessUtil {
    public static AccessRule createAccessRule(Subject[] subjects, Permission[] permissions) {
        AccessRule ar = new AccessRule();
        for (Subject subject : subjects) {
            ar.addSubject(subject);
        }
        for (Serializable serializable : permissions) {
            ar.addPermission((Permission)serializable);
        }
        return ar;
    }

    public static AccessRule createAccessRule(String[] subjectStrings, Permission[] permissions) {
        AccessRule ar = new AccessRule();
        for (String subjectStr : subjectStrings) {
            Subject s = new Subject();
            s.setValue(subjectStr);
            ar.addSubject(s);
        }
        for (Permission permission : permissions) {
            ar.addPermission(permission);
        }
        return ar;
    }

    public static AccessPolicy createSingleRuleAccessPolicy(String[] subjectStrings, Permission[] permissions) {
        AccessPolicy ap = new AccessPolicy();
        ap.addAllow(AccessUtil.createAccessRule(subjectStrings, permissions));
        return ap;
    }

    public static List<Subject> createSubjectList(String[] subjectStrings) {
        Vector<Subject> subjectList = new Vector<Subject>();
        for (int i = 0; i < subjectStrings.length; ++i) {
            Subject s = new Subject();
            s.setValue(subjectStrings[i]);
            subjectList.add(s);
        }
        return subjectList;
    }

    public static Permission[] createReadWritePermissions() {
        return new Permission[]{Permission.READ, Permission.WRITE};
    }

    public static Permission[] createReadWriteChangePermissions() {
        return new Permission[]{Permission.READ, Permission.WRITE, Permission.CHANGE_PERMISSION};
    }

    public static List<Permission> createReadWritePermissionList() {
        Permission[] p = AccessUtil.createReadWritePermissions();
        return Arrays.asList(p);
    }

    public static List<Permission> createReadWriteChangePermissionList() {
        Permission[] p = AccessUtil.createReadWriteChangePermissions();
        return Arrays.asList(p);
    }

    public static HashMap<Subject, Set<Permission>> getPermissionMap(AccessPolicy policy) {
        HashMap<Subject, Set<Permission>> permissionMap = new HashMap<Subject, Set<Permission>>();
        if (policy != null) {
            for (int i = 0; i < policy.sizeAllowList(); ++i) {
                AccessRule ar = policy.getAllow(i);
                for (int j = 0; j < ar.sizeSubjectList(); ++j) {
                    Subject s = ar.getSubject(j);
                    TreeSet<Permission> perms = new TreeSet<Permission>();
                    for (int k = 0; k < ar.sizePermissionList(); ++k) {
                        perms.add(ar.getPermission(k));
                    }
                    if (permissionMap.containsKey(s)) {
                        permissionMap.get(s).addAll(perms);
                        continue;
                    }
                    permissionMap.put(s, perms);
                }
            }
        }
        return permissionMap;
    }

    public static AccessPolicy buildAccessPolicy(HashMap<Subject, Set<Permission>> pmap) {
        AccessPolicy accessPolicy = new AccessPolicy();
        Iterator<Subject> it = pmap.keySet().iterator();
        while (it.hasNext()) {
            AccessRule rule = new AccessRule();
            Subject subject = it.next();
            rule.addSubject(subject);
            rule.setPermissionList(new ArrayList<Permission>((Collection)pmap.get(subject)));
            accessPolicy.addAllow(rule);
        }
        return accessPolicy;
    }

    public static AccessPolicy cloneAccessPolicy(AccessPolicy orig) {
        if (orig == null) {
            return null;
        }
        AccessPolicy clone = new AccessPolicy();
        if (orig.getAllowList() != null) {
            for (AccessRule ar : orig.getAllowList()) {
                clone.addAllow(AccessUtil.cloneAccessRule(ar));
            }
        }
        return clone;
    }

    public static AccessRule cloneAccessRule(AccessRule orig) {
        if (orig == null) {
            return null;
        }
        AccessRule clone = new AccessRule();
        if (orig.getSubjectList() != null) {
            for (Subject s : orig.getSubjectList()) {
                Subject newSubject = new Subject();
                newSubject.setValue(s.getValue());
                clone.addSubject(newSubject);
            }
        }
        if (orig.getPermissionList() != null) {
            for (Permission p : orig.getPermissionList()) {
                clone.addPermission(p);
            }
        }
        return clone;
    }

    public static AccessPolicy addPublicAccess(AccessPolicy origPolicy) {
        AccessPolicy returnPolicy = null;
        returnPolicy = origPolicy == null ? new AccessPolicy() : origPolicy;
        Subject publick = new Subject();
        publick.setValue("public");
        HashMap<Subject, Set<Permission>> perms = AccessUtil.getPermissionMap(origPolicy);
        if (!perms.containsKey(publick) || ((Set)perms.get(publick)).isEmpty()) {
            AccessRule ar = new AccessRule();
            ar.addSubject(publick);
            ar.addPermission(Permission.READ);
            returnPolicy.addAllow(ar);
        }
        return returnPolicy;
    }
}

