/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dtx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.exolab.castor.dtx.DTXClassDescriptor;
import org.exolab.castor.dtx.DTXEngine;
import org.exolab.castor.dtx.DTXException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.Sql;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;
import org.xml.sax.DocumentHandler;
import org.xml.sax.helpers.AttributeListImpl;

public class DTXQuery {
    protected DTXEngine _eng = null;
    protected DocumentHandler _handler = null;
    protected PrintWriter _logWriter = null;
    protected PreparedStatement _stmt = null;
    protected String _objName = null;
    protected String _objType = null;
    protected ClassMapping _clsMapping = null;
    protected ArrayList _ids = null;
    protected int _lastCol = 0;
    protected HashMap _cols = null;
    protected HashMap _classes = null;

    public void setHandler(DocumentHandler handler) {
        this._handler = handler;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this._logWriter = logWriter;
    }

    public void bind(int param, Object value) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setObject(param, value);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    public void bind(int param, String value) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setString(param, value);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    public void bind(int param, int value) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setInt(param, value);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    public void bind(int param, long value) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setLong(param, value);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    public void bind(int param, float value) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setFloat(param, value);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    public void bind(int param, double value) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setDouble(param, value);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    public void bind(int param, boolean value) throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            this._stmt.setBoolean(param, value);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    public void execute() throws DTXException {
        if (this._stmt == null) {
            throw new DTXException("No prepared statement.");
        }
        try {
            ResultSet rs = this._stmt.executeQuery();
            this.emitSaxEvents(rs);
            rs.close();
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    DTXQuery() {
    }

    void setEngine(DTXEngine eng) {
        this._eng = eng;
    }

    void prepare(String oql) throws DTXException {
        try {
            String sql = this.parseOQL(oql);
            Connection conn = this._eng.getConnection();
            this._stmt = conn.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            throw new DTXException(sqle);
        }
    }

    protected void emitSaxEvents(ResultSet rs) throws DTXException {
        try {
            if (rs.next()) {
                this.emitSaxInt(rs, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace(this._logWriter);
            throw new DTXException(e);
        }
    }

    protected boolean emitSaxInt(ResultSet rs, int idIndex) throws DTXException {
        boolean hasValue = true;
        try {
            String initParentValue = null;
            String parentValue = null;
            int parentColNum = 0;
            if (idIndex != 0) {
                String parentCol = (String)this._ids.get(idIndex - 1);
                Integer parentColInt = (Integer)this._cols.get(parentCol);
                parentColNum = parentColInt;
                parentValue = initParentValue = rs.getString(parentColNum);
            }
            String idCol = (String)this._ids.get(idIndex);
            Integer idColNum = (Integer)this._cols.get(idCol);
            DTXClassDescriptor desc = (DTXClassDescriptor)this._classes.get(idCol);
            ClassMapping clsMapping = desc.getClassMapping();
            String elementName = null;
            elementName = clsMapping.getMapTo() == null || clsMapping.getMapTo().getXml() == null ? clsMapping.getName() : clsMapping.getMapTo().getXml();
            String[] attrCols = desc.getAttrCols();
            String[] simpleElementCols = desc.getSimpleElementCols();
            String textCol = desc.getTextCol();
            while (hasValue && (idIndex == 0 || parentValue.equalsIgnoreCase(initParentValue))) {
                String newIdVal;
                if (idIndex == 0) {
                    this._handler.startDocument();
                }
                String idVal = rs.getString(idColNum);
                AttributeListImpl attrs = new AttributeListImpl();
                int i = 0;
                while (i < attrCols.length) {
                    String attrCol = attrCols[i];
                    Integer attrColNum = (Integer)this._cols.get(attrCol);
                    FieldMapping field = desc.getAttr(attrCol);
                    String attrName = null;
                    attrName = field.getBindXml() == null || field.getBindXml().getName() == null ? field.getName() : field.getBindXml().getName();
                    String attrValue = rs.getString(attrColNum);
                    attrs.addAttribute(attrName, "CDATA", attrValue);
                    ++i;
                }
                this._handler.startElement(elementName, attrs);
                int j = 0;
                while (j < simpleElementCols.length) {
                    String simpleElementCol = simpleElementCols[j];
                    Integer elementColNum = (Integer)this._cols.get(simpleElementCol);
                    FieldMapping elField = desc.getSimpleElement(simpleElementCol);
                    String elName = null;
                    elName = elField.getBindXml() == null || elField.getBindXml().getName() == null ? elField.getName() : elField.getBindXml().getName();
                    String elValue = rs.getString(elementColNum);
                    this._handler.startElement(elName, new AttributeListImpl());
                    this._handler.characters(elValue.toCharArray(), 0, elValue.length());
                    this._handler.endElement(elName);
                    ++j;
                }
                if (idIndex < this._ids.size() - 1) {
                    hasValue = this.emitSaxInt(rs, idIndex + 1);
                }
                if (textCol != null) {
                    Integer textColNum = (Integer)this._cols.get(textCol);
                    String textColValue = rs.getString(textColNum);
                    this._handler.characters(textColValue.toCharArray(), 0, textColValue.length());
                }
                this._handler.endElement(elementName);
                if (idIndex == 0) {
                    this._handler.endDocument();
                }
                if ((newIdVal = rs.getString(idColNum)).equalsIgnoreCase(idVal)) {
                    hasValue = rs.next();
                }
                if (!hasValue || idIndex == 0) continue;
                parentValue = rs.getString(parentColNum);
            }
        }
        catch (Exception e) {
            e.printStackTrace(this._logWriter);
            throw new DTXException(e);
        }
        return hasValue;
    }

    protected String parseOQL(String oql) throws DTXException {
        try {
            this._ids = new ArrayList();
            this._cols = new HashMap();
            this._classes = new HashMap();
            StringTokenizer token = new StringTokenizer(oql);
            if (!token.hasMoreTokens() || !token.nextToken().equalsIgnoreCase("SELECT")) {
                throw new DTXException("Query must start with SELECT");
            }
            if (!token.hasMoreTokens()) {
                throw new DTXException("Missing object name");
            }
            this._objName = token.nextToken();
            if (!token.hasMoreTokens() || !token.nextToken().equalsIgnoreCase("FROM")) {
                throw new DTXException("Object must be followed by FROM");
            }
            if (!token.hasMoreTokens()) {
                throw new DTXException("Missing object type");
            }
            this._objType = token.nextToken();
            if (!token.hasMoreTokens()) {
                throw new DTXException("Missing object name");
            }
            if (!this._objName.equals(token.nextToken())) {
                throw new DTXException("Object name not same in SELECT and FROM");
            }
            if (this._logWriter != null) {
                this._logWriter.println("Querying " + this._objName + " of type " + this._objType);
            }
            this._clsMapping = this._eng.getClassMapping(this._objType);
            if (this._clsMapping == null) {
                throw new DTXException("dtx.NoClassDescription: " + this._objType);
            }
            PersistenceFactory factory = this._eng.getFactory();
            if (factory == null) {
                throw new DTXException("dtx.NoFactory");
            }
            QueryExpression expr = factory.getQueryExpression();
            if (expr == null) {
                throw new DTXException("dtx.NoQueryExpression");
            }
            this.initQuery(this._clsMapping, expr);
            if (token.hasMoreTokens()) {
                if (!token.nextToken().equalsIgnoreCase("WHERE")) {
                    throw new DTXException("Missing WHERE clause");
                }
                this.addField(this._clsMapping, token, expr);
                while (token.hasMoreTokens()) {
                    if (!token.nextToken().equals("AND")) {
                        throw new QueryException("Only AND supported in WHERE clause");
                    }
                    this.addField(this._clsMapping, token, expr);
                }
            }
            String sql = expr.getStatement(false);
            sql = sql + " ORDER BY ";
            Iterator it = ((AbstractList)this._ids).iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                sql = sql + " " + id;
                if (!it.hasNext()) continue;
                sql = sql + ",";
            }
            if (this._logWriter != null) {
                this._logWriter.println("SQL: " + sql);
            }
            return sql;
        }
        catch (Exception e) {
            if (this._logWriter != null) {
                e.printStackTrace(this._logWriter);
            }
            throw new DTXException(e);
        }
    }

    protected void initQuery(ClassMapping clsMapping, QueryExpression expr) throws DTXException {
        MapTo mapTo = clsMapping.getMapTo();
        if (mapTo == null) {
            throw new DTXException("no table mapping for: " + clsMapping.getName());
        }
        String table = mapTo.getTable();
        FieldMapping[] fields = clsMapping.getFieldMapping();
        FieldMapping identity = null;
        String identityName = clsMapping.getIdentity(0);
        int j = 0;
        while (j < fields.length) {
            if (fields[j].getName().equals(identityName)) {
                identity = fields[j];
                break;
            }
            ++j;
        }
        if (identity == null) {
            throw new DTXException("no identity field in class: " + clsMapping.getName());
        }
        Sql identitySQLElement = identity.getSql();
        if (identitySQLElement == null) {
            throw new DTXException("no identity SQL info in class: " + clsMapping.getName());
        }
        String identitySQL = identitySQLElement.getName()[0];
        this._ids.add(table + "." + identitySQL);
        DTXClassDescriptor desc = new DTXClassDescriptor(clsMapping);
        this._classes.put(table + "." + identitySQL, desc);
        if (clsMapping.getExtends() != null) {
            MapTo extendsTo = new MapTo();
            if (extendsTo == null) {
                throw new DTXException("no mapping info for extends table.");
            }
            String extendsTable = extendsTo.getTable();
            expr.addInnerJoin(table, identitySQL, extendsTable, identitySQL);
            this.initQuery(new ClassMapping(), expr);
        }
        int i = 0;
        while (i < fields.length) {
            FieldMapping field = fields[i];
            Sql fieldSql = field.getSql();
            ClassMapping relMapping = this._eng.getClassMapping(field.getType());
            if (fieldSql == null) {
                if (relMapping != null) {
                    FieldMapping[] relFields = relMapping.getFieldMapping();
                    MapTo relMapTo = relMapping.getMapTo();
                    if (relMapTo == null) {
                        throw new DTXException("dtx.NoRelatedMapTo");
                    }
                    String relTable = relMapTo.getTable();
                    Object relId = null;
                    String foreKey = null;
                    int k = 0;
                    while (k < relFields.length) {
                        String type;
                        Sql relSql = relFields[k].getSql();
                        if (relSql != null && (type = relFields[k].getType()) != null && type.equals(clsMapping.getName())) {
                            foreKey = relSql.getName()[0];
                        }
                        ++k;
                    }
                    if (foreKey != null) {
                        expr.addOuterJoin(table, identitySQL, relTable, foreKey);
                        DTXClassDescriptor relDesc = new DTXClassDescriptor(relMapping);
                        int n = 0;
                        while (n < relFields.length) {
                            FieldMapping relField = relFields[n];
                            Sql relSql = relFields[n].getSql();
                            if (relSql != null) {
                                String relFieldName = relSql.getName()[0];
                                if (relFieldName == null) {
                                    relFieldName = relFields[n].getName();
                                }
                                String relFullName = relTable + "." + relFieldName;
                                BindXml relFieldXml = relFields[n].getBindXml();
                                String node = "element";
                                if (relFieldXml != null) {
                                    node = relFieldXml.getNode().toString();
                                }
                                if (!relFieldName.equals(foreKey)) {
                                    expr.addColumn(relTable, relFieldName);
                                    this._cols.put(relTable + "." + relFieldName, new Integer(++this._lastCol));
                                    if (node.equalsIgnoreCase("attribute")) {
                                        relDesc.addAttr(relFullName, relField);
                                    } else if (node.equalsIgnoreCase("element")) {
                                        relDesc.addSimpleElement(relFullName, relField);
                                    } else if (node.equalsIgnoreCase("text")) {
                                        relDesc.setTextCol(relFullName, relField);
                                    }
                                }
                                if (relField.getName().equals(relMapping.getIdentity())) {
                                    this._ids.add(relTable + "." + relFieldName);
                                    desc.addContained(relTable + "." + relFieldName, relMapping);
                                    this._classes.put(relTable + "." + relFieldName, relDesc);
                                }
                            }
                            ++n;
                        }
                    }
                }
            } else {
                String fieldName = fieldSql.getName()[0];
                if (fieldName == null) {
                    fieldName = fields[i].getName();
                }
                String fullName = table + "." + fieldName;
                BindXml fieldXml = field.getBindXml();
                String node = "element";
                if (fieldXml != null) {
                    node = fieldXml.getNode().toString();
                }
                if (node.equalsIgnoreCase("attribute")) {
                    desc.addAttr(fullName, field);
                } else if (node.equalsIgnoreCase("element")) {
                    desc.addSimpleElement(fullName, field);
                } else if (node.equalsIgnoreCase("text")) {
                    desc.setTextCol(fullName, field);
                }
                if (relMapping == null || fieldSql.getManyTable() == null) {
                    expr.addColumn(table, fieldName);
                    this._cols.put(fullName, new Integer(++this._lastCol));
                } else {
                    expr.addColumn(fieldSql.getManyTable(), fieldName);
                    this._cols.put(fullName, new Integer(++this._lastCol));
                    expr.addOuterJoin(table, identitySQL, fieldSql.getManyTable(), fieldSql.getManyKey()[0]);
                }
            }
            ++i;
        }
    }

    private void addField(ClassMapping clsMapping, StringTokenizer token, QueryExpression expr) throws DTXException {
        if (!token.hasMoreTokens()) {
            throw new DTXException("Missing field name");
        }
        String name = token.nextToken();
        if (!token.hasMoreTokens()) {
            throw new DTXException("Missing operator");
        }
        String op = token.nextToken();
        if (!token.hasMoreTokens()) {
            throw new DTXException("Missing field value");
        }
        String value = token.nextToken();
        if (name.indexOf(".") > 0) {
            name = name.substring(name.indexOf(".") + 1);
        }
        FieldMapping[] fields = clsMapping.getFieldMapping();
        FieldMapping field = null;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getSql() != null && fields[i].getName().equals(name)) {
                field = fields[i];
                break;
            }
            ++i;
        }
        if (field == null) {
            throw new DTXException("The field " + name + " was not found");
        }
        Sql fieldSql = field.getSql();
        String table = clsMapping.getMapTo().getTable();
        if (value.startsWith("$")) {
            expr.addParameter(table, fieldSql.getName()[0], op);
        } else {
            expr.addCondition(table, fieldSql.getName()[0], op, value);
        }
    }
}

