/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.LoadListener;
import com.google.gwt.user.client.ui.LoadListenerCollection;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerCollection;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesLoadEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;

public class Image
extends Widget
implements SourcesClickEvents,
SourcesMouseEvents,
SourcesLoadEvents {
    private static HashMap prefetchImages = new HashMap();
    private ClickListenerCollection clickListeners;
    private LoadListenerCollection loadListeners;
    private MouseListenerCollection mouseListeners;

    public static void prefetch(String url) {
        Element img = DOM.createImg();
        DOM.setAttribute(img, "src", url);
        prefetchImages.put(url, img);
    }

    public Image() {
        this.setElement(DOM.createImg());
        this.sinkEvents(98429);
        this.setStyleName("gwt-Image");
    }

    public Image(String url) {
        this();
        this.setUrl(url);
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
        }
        this.clickListeners.add(listener);
    }

    public void addLoadListener(LoadListener listener) {
        if (this.loadListeners == null) {
            this.loadListeners = new LoadListenerCollection();
        }
        this.loadListeners.add(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new MouseListenerCollection();
        }
        this.mouseListeners.add(listener);
    }

    public String getUrl() {
        return DOM.getAttribute(this.getElement(), "src");
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (this.clickListeners == null) break;
                this.clickListeners.fireClick(this);
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 32768: {
                if (this.loadListeners == null) break;
                this.loadListeners.fireLoad(this);
                break;
            }
            case 65536: {
                if (this.loadListeners == null) break;
                this.loadListeners.fireError(this);
            }
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void removeLoadListener(LoadListener listener) {
        if (this.loadListeners != null) {
            this.loadListeners.remove(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(listener);
        }
    }

    public void setUrl(String url) {
        DOM.setAttribute(this.getElement(), "src", url);
    }
}

