/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class OPTRecord
extends Record {
    private static OPTRecord member = new OPTRecord();
    private Map options;

    private OPTRecord() {
    }

    private OPTRecord(Name name, short dclass, int ttl) {
        super(name, (short)41, dclass, ttl);
    }

    static OPTRecord getMember() {
        return member;
    }

    public OPTRecord(short payloadSize, byte xrcode, byte version, int flags) {
        this(Name.root, payloadSize, (xrcode << 24) + (version << 16) + flags);
        this.options = null;
    }

    public OPTRecord(short payloadSize, byte xrcode, byte version) {
        this(payloadSize, xrcode, version, 0);
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        OPTRecord rec = new OPTRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        int count = 0;
        if (count < length) {
            rec.options = new HashMap();
        }
        while (count < length) {
            int code = in.readUnsignedShort();
            int len = in.readUnsignedShort();
            byte[] data = new byte[len];
            in.read(data);
            count += 4 + len;
            rec.options.put(new Integer(code), data);
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        throw new TextParseException("no text format defined for OPT");
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("\t");
        sb.append(Type.string(this.getType()));
        if (this.options != null) {
            Iterator it = this.options.keySet().iterator();
            while (it.hasNext()) {
                Integer i = (Integer)it.next();
                sb.append(i + " ");
            }
        }
        sb.append(" ; payload ");
        sb.append(this.getPayloadSize());
        sb.append(", xrcode ");
        sb.append(this.getExtendedRcode());
        sb.append(", version ");
        sb.append(this.getVersion());
        sb.append(", flags ");
        sb.append(this.getFlags());
        return sb.toString();
    }

    public short getPayloadSize() {
        return this.dclass;
    }

    public short getExtendedRcode() {
        return (short)(this.ttl >>> 24);
    }

    public short getVersion() {
        return (short)(this.ttl >>> 16 & 0xFF);
    }

    public int getFlags() {
        return this.ttl & 0xFFFF;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.options == null) {
            return;
        }
        Iterator it = this.options.keySet().iterator();
        while (it.hasNext()) {
            Integer i = (Integer)it.next();
            short key = i.shortValue();
            out.writeShort(key);
            byte[] data = (byte[])this.options.get(i);
            out.writeShort(data.length);
            out.writeArray(data);
        }
    }
}

