/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.cache;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.client.cache.LSIDCachingInputStream;
import com.ibm.lsid.client.cache.LSIDCachingInputStreamListener;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LSIDCache
implements Comparator {
    public static final String DEFAULT_CACHE_DIR_WIN32 = "/lsid-client/cache";
    public static final String DEFAULT_CACHE_DIR_UNIX = "~/.lsid-client/cache";
    public static final String CACHE_CONFIG_FILE = "lsid-cache.properties";
    public static final String CACHE_DIR_PROPERTY = "LSID_CACHE_DIR";
    public static final String MAX_CACHE_SIZE = "max-cache-size";
    public static final String MAX_CACHE_LIFETIME = "max-cache-lifetime";
    public static final String MAX_CACHE_SIZE_HIGH = "max-cache-size-high";
    public static final String MAX_CACHE_LIFETIME_HIGH = "max-cache-lifetime-high";
    public static final String LOGGING_ON = "logging-on";
    public static final String MANGLE_CASE = "mangle-case";
    public static final String LOG_FILE = "log-file";
    private static final String STD_ERR = "std-err";
    private static final String DATA_EXT = "tmp";
    private static final String EXPIRATION_FILENAME = "EXPIRES";
    private static final String COMPLETE_FILE = "complete.tmp";
    private static final Hashtable METADATA_TYPE_2_EXTENSION = new Hashtable();
    private static final String[] ALL_FORMATS = new String[]{"application/xml+rdf", "application/xml+xmi", "application/octet-stream", null};
    private static final SimpleDateFormat LOG_DATE_FORMAT;
    private int maxCacheSize = -1;
    private int maxCacheLifetime = -1;
    private boolean loggingOn = false;
    private String logFile = "std-err";
    private int mangleCase = 0;
    private static final int MANGLE_SYSTEM = 0;
    private static final int MANGLE_ON = 1;
    private static final int MANGLE_SHA1 = 2;
    private static final int MANGLE_OFF = -1;
    private static File cacheDir;
    private PrintWriter logFileWriter;
    private static LSIDCache singletonInstance;

    public static synchronized LSIDCache load() throws LSIDCacheException {
        String dirprop = System.getProperty(CACHE_DIR_PROPERTY);
        boolean newCacheDir = true;
        if (singletonInstance != null && dirprop != null) {
            File temp = new File(dirprop);
            boolean bl = newCacheDir = !temp.equals(cacheDir);
        }
        if (newCacheDir) {
            char sep;
            File cacheDir = null;
            cacheDir = dirprop == null ? ((sep = File.separatorChar) == '/' ? new File(DEFAULT_CACHE_DIR_UNIX) : new File(DEFAULT_CACHE_DIR_WIN32)) : new File(dirprop);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            singletonInstance = new LSIDCache(null, cacheDir);
        }
        return singletonInstance;
    }

    public static LSIDCache load(File cacheDir) throws LSIDCacheException {
        return new LSIDCache(null, cacheDir);
    }

    public static String getLocation() {
        try {
            return cacheDir.getCanonicalPath();
        }
        catch (IOException e) {
            System.err.println("Error canonicalizing path to cache dir: " + cacheDir.toString());
            e.printStackTrace();
            return e.toString();
        }
    }

    public String getLogFileName() {
        return this.logFile;
    }

    public LSIDWSDLWrapper readWSDL(LSIDAuthority auth, LSID lsid) throws LSIDException {
        String fileName = null;
        fileName = lsid != null ? this.canonicalizeFilename(lsid.toString()) : "authority";
        fileName = fileName + ".wsdl";
        File file = new File(cacheDir, "/wsdl/" + auth + "/" + fileName);
        if (!file.exists()) {
            return null;
        }
        Hashtable expEntries = this.loadExpirationEntries(file.getParentFile());
        if (LSIDCache.fileExpired(expEntries, fileName)) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            LSIDWSDLWrapper wsdl = new LSIDWSDLWrapper(in);
            long exp = LSIDCache.getExpiration(expEntries, fileName);
            if (exp != -1L) {
                wsdl.setExpiration(new Date(exp));
            }
            if (this.getLoggingOn()) {
                if (lsid != null) {
                    this.logOpenClose(new File(cacheDir, "/wsdl/" + auth), "Read WSDL for " + lsid);
                } else {
                    this.logOpenClose(new File(cacheDir, "/wsdl/" + auth), "Read WSDL for " + auth);
                }
            }
            LSIDWSDLWrapper lSIDWSDLWrapper = wsdl;
            return lSIDWSDLWrapper;
        }
        catch (IOException e) {
            throw new LSIDCacheException(e, "Error reading WSDL cache file: " + fileName);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new LSIDCacheException(e, "Error closing WSDL cache file: " + fileName);
            }
        }
    }

    public synchronized InputStream readData(LSID lsid, int start, int length) throws LSIDCacheException {
        File dir = new File(cacheDir, "/data/" + this.canonicalizeFilename(lsid.toString()));
        File file = new File(dir, COMPLETE_FILE);
        if (file.exists()) {
            try {
                if (this.getLoggingOn()) {
                    this.logOpenClose(dir, "Read data for " + lsid);
                }
                FileInputStream in = new FileInputStream(file);
                if (start != -1) {
                    in.skip(start);
                }
                return in;
            }
            catch (IOException e) {
                throw new LSIDCacheException(e, "Error opening data cache file " + file);
            }
        }
        if (start == -1 && length == -1) {
            return null;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        File f = null;
        int s = -1;
        int l = -1;
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            if (name.startsWith("range")) {
                int ind = name.lastIndexOf(95);
                s = Integer.parseInt(name.substring(6, ind));
                l = Integer.parseInt(name.substring(ind + 1, name.indexOf(46)));
                if (s <= start && s + l >= start + length) {
                    f = files[i];
                    break;
                }
            }
            ++i;
        }
        if (f != null) {
            try {
                if (this.getLoggingOn()) {
                    this.logOpenClose(dir, "Read data for " + lsid);
                }
                FileInputStream in = new FileInputStream(f);
                in.skip(start - s);
                return in;
            }
            catch (IOException e) {
                throw new LSIDCacheException(e, "Error opening data cache file " + f);
            }
        }
        return null;
    }

    public synchronized MetadataResponse readMetadata(LSIDAuthority authority, LSID lsid, String serviceName, String portName, String[] acceptedFormats) throws LSIDCacheException {
        if (acceptedFormats == null) {
            acceptedFormats = ALL_FORMATS;
        }
        int i = 0;
        while (i < acceptedFormats.length) {
            String fileName = serviceName + "." + portName;
            fileName = acceptedFormats[i] != null ? fileName + "." + METADATA_TYPE_2_EXTENSION.get(acceptedFormats[i]) : fileName + ".tmp";
            File file = new File(cacheDir, "/metadata/" + authority + "/" + this.canonicalizeFilename(lsid.toString()) + "/" + fileName);
            Hashtable expEntries = this.loadExpirationEntries(file.getParentFile());
            if (file.exists() && !LSIDCache.fileExpired(expEntries, fileName)) {
                try {
                    if (this.getLoggingOn()) {
                        this.logOpenClose(new File(cacheDir, "/metadata/" + authority + "/" + this.canonicalizeFilename(lsid.toString())), "Read meta data for " + lsid + " at: " + serviceName + "." + portName);
                    }
                    return new MetadataResponse((Object)new FileInputStream(file), LSIDCache.getExpiration(expEntries, fileName), acceptedFormats[i]);
                }
                catch (FileNotFoundException e) {
                    throw new LSIDCacheException(e, "Error opening meta data cache file " + file);
                }
            }
            ++i;
        }
        return null;
    }

    public void writeWSDL(LSIDAuthority auth, LSID lsid, LSIDWSDLWrapper wsdl) throws LSIDCacheException {
        File dir = new File(cacheDir, "/wsdl/" + auth);
        dir.mkdirs();
        String fileName = null;
        String logStr = null;
        if (lsid != null) {
            fileName = this.canonicalizeFilename(lsid.toString());
            logStr = lsid.toString();
        } else {
            fileName = "authority";
            logStr = auth.toString();
        }
        fileName = fileName + ".wsdl";
        File file = new File(dir, fileName);
        FileOutputStream out = null;
        File cacheDir = new File(LSIDCache.getLocation(), "/temp/");
        cacheDir.mkdirs();
        try {
            File tempFile = File.createTempFile("cache", DATA_EXT, cacheDir);
            out = new FileOutputStream(tempFile);
            out.write(wsdl.toString().getBytes());
            out.flush();
            out.close();
            if (file.exists()) {
                file.delete();
            }
            tempFile.renameTo(file);
            tempFile.delete();
            this.logOpenClose(dir, "Wrote WSDL for " + logStr);
        }
        catch (IOException e) {
            throw new LSIDCacheException(e, "Error writing WSDL for " + logStr);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new LSIDCacheException(e, "Error closing WSDL cache file for " + logStr);
            }
        }
        Date expiration = wsdl.getExpiration();
        if (expiration != null) {
            this.updateExpirationEntry(dir, fileName, expiration.getTime());
        }
    }

    public InputStream writeData(LSID lsid, InputStream data, int start, int length) throws LSIDCacheException {
        File dir = new File(cacheDir, "/data/" + this.canonicalizeFilename(lsid.toString()));
        dir.mkdirs();
        String fileName = null;
        fileName = start == -1 && length == -1 ? COMPLETE_FILE : "range_" + start + "_" + length + "." + DATA_EXT;
        File file = new File(dir, fileName);
        LSIDCachingInputStream lcis = new LSIDCachingInputStream(data, file, null, lsid);
        lcis.setInputStreamListener(new LSIDCachingInputStreamListener(){

            public void inputStreamClosed(LSIDAuthority authority, LSID lsid) throws IOException {
                try {
                    File dir = new File(cacheDir, "/data/" + LSIDCache.this.canonicalizeFilename(lsid.toString()));
                    LSIDCache.this.logOpenClose(dir, "Wrote data for " + lsid);
                }
                catch (LSIDCacheException e) {
                    e.printStackTrace();
                    throw new IOException("Error handling inputStreamClosed event for " + lsid + " : " + e.getMessage());
                }
            }
        });
        return lcis;
    }

    public synchronized InputStream writeMetadata(LSIDAuthority authority, LSID lsid, String serviceName, String portName, InputStream data, Date expiration, String format) throws LSIDCacheException {
        File dir = new File(cacheDir, "/metadata/" + authority + "/" + this.canonicalizeFilename(lsid.toString()));
        String fileName = serviceName + "." + portName;
        fileName = format != null ? fileName + "." + METADATA_TYPE_2_EXTENSION.get(format) : fileName + ".tmp";
        File file = new File(dir, fileName);
        LSIDCachingInputStream lcis = new LSIDCachingInputStream(data, file, authority, lsid);
        final String location = fileName;
        final Date exp = expiration;
        lcis.setInputStreamListener(new LSIDCachingInputStreamListener(){

            public void inputStreamClosed(LSIDAuthority authority, LSID lsid) throws IOException {
                try {
                    File dir = new File(cacheDir, "/metadata/" + authority + "/" + LSIDCache.this.canonicalizeFilename(lsid.toString()));
                    LSIDCache.this.logOpenClose(dir, "Wrote meta data for " + lsid + " at: " + location);
                    if (exp != null) {
                        LSIDCache.this.updateExpirationEntry(dir, location, exp.getTime());
                    }
                }
                catch (LSIDCacheException e) {
                    e.printStackTrace();
                    throw new IOException("Error handling inputStreamClosed event for " + lsid + " : " + e.getMessage());
                }
            }
        });
        return lcis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainCache() throws LSIDCacheException {
        this.openLogWriter();
        try {
            this.maintainCache(-1L);
            Object var2_1 = null;
            this.closeLogWriter();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.closeLogWriter();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private LSIDCache(LSIDCache parent, File cacheDir) throws LSIDCacheException {
        super();
        LSIDCache.cacheDir = cacheDir;
        cacheFile = new File(cacheDir, "lsid-cache.properties");
        if (cacheFile.exists()) {
            in = null;
            try {
                props = new Properties();
                in = new FileInputStream(cacheFile);
                props.load(in);
                mcs = props.getProperty("max-cache-size");
                mcl = props.getProperty("max-cache-lifetime");
                mcshigh = props.getProperty("max-cache-size-high");
                mclhigh = props.getProperty("max-cache-lifetime-high");
                mangle = props.getProperty("mangle-case");
                log = props.getProperty("logging-on");
                this.logFile = props.getProperty("log-file");
                try {
                    this.maxCacheSize = Integer.parseInt(mcs);
                }
                catch (Exception e) {
                    throw new LSIDCacheException(e, "Error parsing cache config value: " + mcs);
                }
                if (mangle != null) {
                    try {
                        this.mangleCase = Integer.parseInt(mangle);
                        if (this.mangleCase != -1 && this.mangleCase != 1 && this.mangleCase != 0 && this.mangleCase != 2) {
                            throw new LSIDCacheException("Error parsing cache config mangle value: " + mangle);
                        }
                    }
                    catch (Exception e) {
                        throw new LSIDCacheException(e, "Error parsing cache config mangle value: " + mangle);
                    }
                }
                if (mcshigh != null) {
                    try {
                        i = Integer.parseInt(mcshigh);
                        this.maxCacheSize = (i <<= 32) + this.maxCacheSize;
                    }
                    catch (Exception e) {
                        throw new LSIDCacheException(e, "Error parsing cache config value: " + mcshigh);
                    }
                }
                try {
                    this.maxCacheLifetime = Integer.parseInt(mcl);
                }
                catch (Exception e) {
                    throw new LSIDCacheException(e, "Error parsing cache config value: " + mcl);
                }
                if (mclhigh != null) {
                    try {
                        i = Integer.parseInt(mclhigh);
                        this.maxCacheLifetime = (i <<= 32) + this.maxCacheLifetime;
                    }
                    catch (Exception e) {
                        throw new LSIDCacheException(e, "Error parsing cache config value: " + mclhigh);
                    }
                }
                try {
                    this.loggingOn = Boolean.valueOf(log);
                }
                catch (Exception e) {
                    throw new LSIDCacheException(e, "Error parsing cache config value: " + log);
                }
                if (parent == null) ** GOTO lbl79
                if (parent.getMaxCacheSize() != -1 && parent.getMaxCacheSize() < this.maxCacheSize) {
                    this.maxCacheSize = parent.getMaxCacheSize();
                }
                if (parent.getMaxCacheLifetime() != -1 && parent.getMaxCacheLifetime() < this.maxCacheLifetime) {
                    this.maxCacheLifetime = parent.getMaxCacheLifetime();
                }
                if (parent.getLoggingOn()) ** GOTO lbl79
                this.loggingOn = false;
            }
            catch (IOException e) {
                throw new LSIDCacheException(e, "Error loading properties file from: " + cacheDir + "/" + "lsid-cache.properties");
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    throw new LSIDCacheException(e, "Error closing properties file from: " + cacheDir + "/" + "lsid-cache.properties");
                }
            }
        } else if (parent != null) {
            this.copyConfig(parent);
        }
lbl79:
        // 6 sources

        if (parent != null) {
            this.logFileWriter = parent.logFileWriter;
        }
    }

    private Vector maintainCache(long timestamp) throws LSIDCacheException {
        if (timestamp == -1L) {
            timestamp = System.currentTimeMillis();
        }
        this.log(cacheDir, "Beginning cache maintenance");
        Vector<File> remainingFiles = new Vector<File>();
        File[] dirListing = cacheDir.listFiles();
        int i = 0;
        while (i < dirListing.length) {
            File file = dirListing[i];
            if (file.isDirectory()) {
                remainingFiles.addAll(new LSIDCache(this, file).maintainCache(timestamp));
                if (file.list().length == 0) {
                    this.log(cacheDir, "Directory " + file.getName() + " is empty, removing");
                    file.delete();
                }
            } else if (!file.getName().equals(CACHE_CONFIG_FILE) && !file.getName().equals(this.logFile) && !file.getName().equals(EXPIRATION_FILENAME) && this.filterFileByDate(file, timestamp)) {
                remainingFiles.add(file);
            }
            ++i;
        }
        this.filterFilesBySize(remainingFiles);
        this.log(cacheDir, "Cache maintenance complete");
        return remainingFiles;
    }

    private int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    private int getMaxCacheLifetime() {
        return this.maxCacheLifetime;
    }

    private File getCacheDir() {
        return cacheDir;
    }

    private boolean getLoggingOn() {
        return this.loggingOn;
    }

    private String getLogFile() {
        return this.logFile;
    }

    private void openLogWriter() throws LSIDCacheException {
        try {
            if (this.getLoggingOn() && !this.logFile.equals(STD_ERR)) {
                this.logFileWriter = new PrintWriter(new FileWriter(new File(cacheDir, this.logFile).toString(), true));
            }
        }
        catch (IOException e) {
            throw new LSIDCacheException(e, "error opening cache log file: " + cacheDir + "/" + this.logFile);
        }
    }

    private void closeLogWriter() {
        if (this.logFileWriter != null) {
            this.logFileWriter.close();
        }
    }

    private void log(File dir, String msg) {
        if (this.getLoggingOn()) {
            String stamp = LOG_DATE_FORMAT.format(new Date(System.currentTimeMillis()));
            if (this.logFileWriter != null) {
                this.logFileWriter.println("[" + stamp + "]" + "[" + dir + "]" + msg);
                this.logFileWriter.flush();
            } else {
                System.err.println("[" + stamp + "]" + "[" + dir + "]" + msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOpenClose(File dir, String msg) throws LSIDCacheException {
        if (this.getLoggingOn()) {
            try {
                this.openLogWriter();
                this.log(dir, msg);
                Object var4_3 = null;
                this.closeLogWriter();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.closeLogWriter();
                throw throwable;
            }
        }
    }

    private boolean filterFileByDate(File file, long timestamp) {
        if (this.maxCacheLifetime == -1) {
            return true;
        }
        if (timestamp - file.lastModified() >= (long)this.maxCacheLifetime) {
            this.log(cacheDir, "File " + file + " has expired, deleting");
            file.delete();
            return false;
        }
        return true;
    }

    private void filterFilesBySize(Vector files) {
        if (this.maxCacheSize == -1) {
            return;
        }
        Collections.sort(files, this);
        long totalSize = 0L;
        int i = 0;
        while (i < files.size()) {
            totalSize += ((File)files.elementAt(i)).length();
            ++i;
        }
        while (totalSize > (long)this.maxCacheSize || this.maxCacheSize == 0 && files.size() > 0) {
            File file = (File)files.elementAt(0);
            totalSize -= file.length();
            this.log(cacheDir, "Cache too big, removing file " + file.getName());
            file.delete();
            files.removeElementAt(0);
        }
    }

    private static boolean fileExpired(Hashtable entries, String filename) {
        long timestamp = System.currentTimeMillis();
        ExpEntry entry = (ExpEntry)entries.get(filename);
        if (entry == null) {
            return false;
        }
        if (entry.expires == -1L) {
            return false;
        }
        return timestamp >= entry.expires;
    }

    private static long getExpiration(Hashtable entries, String filename) {
        ExpEntry entry = (ExpEntry)entries.get(filename);
        if (entry == null) {
            return -1L;
        }
        return entry.expires;
    }

    private void updateExpirationEntry(File dir, String filename, long expiration) throws LSIDCacheException {
        File expFile = new File(dir, EXPIRATION_FILENAME);
        Hashtable entries = this.loadExpirationEntries(dir);
        entries.put(filename, new ExpEntry(filename, expiration));
        LSIDCache.writeExpirationEntries(dir, entries);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Hashtable loadExpirationEntries(File dir) throws LSIDCacheException {
        File expFile = new File(dir, EXPIRATION_FILENAME);
        if (!expFile.exists()) {
            return new Hashtable();
        }
        BufferedReader reader = null;
        Hashtable<String, ExpEntry> entries = null;
        reader = new BufferedReader(new InputStreamReader(new FileInputStream(expFile)));
        entries = new Hashtable<String, ExpEntry>();
        String line = reader.readLine();
        while (line != null) {
            ExpEntry entry = new ExpEntry(line);
            entries.put(entry.filename, entry);
            line = reader.readLine();
        }
        Object var8_8 = null;
        if (reader == null) return entries;
        try {
            reader.close();
            return entries;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return entries;
        {
            catch (IOException e) {
                throw new LSIDCacheException(e, "Error updating expiration file in directory: " + dir);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    private static void writeExpirationEntries(File dir, Hashtable entries) throws LSIDCacheException {
        File expFile = new File(dir, EXPIRATION_FILENAME);
        PrintWriter writer = null;
        try {
            try {
                if (expFile.exists()) {
                    expFile.delete();
                }
                File cacheDir = new File(LSIDCache.getLocation(), "/temp/");
                cacheDir.mkdirs();
                File tempFile = File.createTempFile("cache", DATA_EXT, cacheDir);
                writer = new PrintWriter(new FileWriter(tempFile.getCanonicalPath(), false));
                Enumeration filenames = entries.keys();
                while (filenames.hasMoreElements()) {
                    ExpEntry entry = (ExpEntry)entries.get(filenames.nextElement());
                    writer.println(entry.filename + ":" + entry.expires);
                    writer.flush();
                }
                writer.close();
                tempFile.renameTo(expFile);
                tempFile.delete();
            }
            catch (IOException e) {
                throw new LSIDCacheException(e, "Error writing expiration file to: " + dir);
            }
            Object var9_9 = null;
            if (writer != null) {
                writer.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (writer != null) {
                writer.close();
            }
            throw throwable;
        }
    }

    public int compare(Object f1, Object f2) {
        long file2mod;
        File file1 = (File)f1;
        File file2 = (File)f2;
        long file1mod = file1.lastModified();
        if (file1mod > (file2mod = file2.lastModified())) {
            return 1;
        }
        if (file1mod < file2mod) {
            return -1;
        }
        return 0;
    }

    private void copyConfig(LSIDCache cache) {
        this.maxCacheLifetime = cache.getMaxCacheLifetime();
        this.maxCacheSize = cache.getMaxCacheSize();
        this.loggingOn = cache.getLoggingOn();
    }

    public String canonicalizeFilename(String name) throws LSIDCacheException {
        if (this.mangleCase == 1) {
            return LSIDCache.getEncodedFilename(name);
        }
        if (this.mangleCase == -1) {
            return LSIDCache.getEncodedFilename(name, false);
        }
        if (this.mangleCase == 2) {
            MessageDigest sha1 = null;
            try {
                sha1 = MessageDigest.getInstance("SHA");
                sha1.update(name.getBytes("UTF-8"));
                byte[] hash = sha1.digest();
                char[] ca = new char[hash.length * 2];
                int i = 0;
                int j = 0;
                while (i < hash.length) {
                    ca[j++] = "0123456789ABCDEF".charAt(hash[i] >> 4 & 0xF);
                    ca[j++] = "0123456789ABCDEF".charAt(hash[i] & 0xF);
                    ++i;
                }
                return new String(ca);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LSIDCacheException("Could not find SHA1 hashing algorithm");
            }
            catch (UnsupportedEncodingException e) {
                throw new LSIDCacheException("Could not find UTF-8 encoding");
            }
        }
        if (File.separatorChar == '/') {
            return LSIDCache.getEncodedFilename(name, false);
        }
        return LSIDCache.getEncodedFilename(name);
    }

    public static LSIDCache getSingletonInstance() {
        return singletonInstance;
    }

    public static String getEncodedFilename(String s, boolean encodeUpperCase) {
        StringBuffer enc = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char temp = s.charAt(i);
            if (temp == '.' || temp == '-' || temp == '_' || temp >= '0' && temp <= '9' || temp >= 'a' && temp <= 'z') {
                enc.append(temp);
            } else if (!encodeUpperCase && temp >= 'A' && temp <= 'Z') {
                enc.append(temp);
            } else {
                enc.append("%" + Integer.toHexString(temp));
            }
            ++i;
        }
        return enc.toString();
    }

    public static String getDecodedFilename(String s) {
        StringBuffer dec = new StringBuffer();
        char[] buf = new char[2];
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '%') {
                buf[0] = s.charAt(i + 1);
                buf[1] = s.charAt(i + 2);
                int hex = Integer.parseInt(new String(buf), 16);
                dec.append(new Character((char)hex).toString());
                i += 2;
            } else {
                dec.append(s.charAt(i));
            }
            ++i;
        }
        return dec.toString();
    }

    public static String getEncodedFilename(String s) {
        return LSIDCache.getEncodedFilename(s, true);
    }

    static {
        METADATA_TYPE_2_EXTENSION.put("application/xml+rdf", "rdf");
        METADATA_TYPE_2_EXTENSION.put("application/xml+xmi", "xmi");
        METADATA_TYPE_2_EXTENSION.put("application/octet-stream", DATA_EXT);
        LOG_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss:SSS");
        singletonInstance = null;
    }

    private static class ExpEntry {
        String filename;
        long expires;

        ExpEntry(String filename, long expires) {
            this.filename = filename;
            this.expires = expires;
        }

        ExpEntry(String entryStr) throws LSIDCacheException {
            int ind = entryStr.indexOf(58);
            if (ind == -1) {
                throw new LSIDCacheException("Bad Expiration file entry: " + entryStr);
            }
            this.filename = entryStr.substring(0, ind);
            try {
                this.expires = Long.parseLong(entryStr.substring(ind + 1));
            }
            catch (NumberFormatException e) {
                throw new LSIDCacheException(e, "Bad Expiration file entry: " + entryStr);
            }
        }
    }
}

