/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public abstract class MX_KXRecord
extends Record {
    protected short priority;
    protected Name target;

    protected MX_KXRecord() {
    }

    protected MX_KXRecord(Name name, short type, short dclass, int ttl) {
        super(name, type, dclass, ttl);
    }

    public MX_KXRecord(Name name, short type, short dclass, int ttl, int priority, Name target) {
        super(name, type, dclass, ttl);
        this.priority = (short)priority;
        this.target = target;
    }

    protected static Record rrFromWire(MX_KXRecord rec, DataByteInputStream in) throws IOException {
        if (in == null) {
            return rec;
        }
        rec.priority = (short)in.readUnsignedShort();
        rec.target = new Name(in);
        return rec;
    }

    protected static Record rdataFromString(MX_KXRecord rec, MyStringTokenizer st, Name origin) throws TextParseException {
        rec.priority = Short.parseShort(st.nextToken());
        rec.target = Name.fromString(st.nextToken(), origin);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.target != null) {
            sb.append(this.priority);
            sb.append(" ");
            sb.append(this.target);
        }
        return sb.toString();
    }

    public Name getTarget() {
        return this.target;
    }

    public short getPriority() {
        return this.priority;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.target == null) {
            return;
        }
        out.writeShort(this.priority);
        if (this.type == 15) {
            this.target.toWire(out, c, canonical);
        } else {
            this.target.toWire(out, null, canonical);
        }
    }

    public Name getAdditionalName() {
        return this.target;
    }
}

