/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class RPRecord
extends Record {
    private static RPRecord member = new RPRecord();
    private Name mailbox;
    private Name textDomain;

    private RPRecord() {
    }

    private RPRecord(Name name, short dclass, int ttl) {
        super(name, (short)17, dclass, ttl);
    }

    static RPRecord getMember() {
        return member;
    }

    public RPRecord(Name name, short dclass, int ttl, Name mailbox, Name textDomain) {
        this(name, dclass, ttl);
        this.mailbox = mailbox;
        this.textDomain = textDomain;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        RPRecord rec = new RPRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.mailbox = new Name(in);
        rec.textDomain = new Name(in);
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        RPRecord rec = new RPRecord(name, dclass, ttl);
        rec.mailbox = Name.fromString(st.nextToken(), origin);
        rec.textDomain = Name.fromString(st.nextToken(), origin);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.mailbox != null && this.textDomain != null) {
            sb.append(this.mailbox);
            sb.append(" ");
            sb.append(this.textDomain);
        }
        return sb.toString();
    }

    public Name getMailbox() {
        return this.mailbox;
    }

    public Name getTextDomain() {
        return this.textDomain;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.mailbox == null || this.textDomain == null) {
            return;
        }
        this.mailbox.toWire(out, null, canonical);
        this.textDomain.toWire(out, null, canonical);
    }
}

