/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.ExpiringResponse;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.server.LSIDAuthorityService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import java.util.Map;

public class CachingAuthorityService
implements LSIDAuthorityService {
    private LSIDAuthorityService service;
    private LSIDCache cache;

    public CachingAuthorityService(LSIDAuthorityService service) {
        this.service = service;
    }

    public ExpiringResponse getAvailableServices(LSIDRequestContext ctx) throws LSIDServerException {
        LSID lsid = ctx.getLsid();
        Map headers = ctx.getProtocalHeaders();
        if (this.cache != null && !headers.containsValue("no-cache")) {
            try {
                LSIDWSDLWrapper response = this.cache.readWSDL(lsid.getAuthority(), lsid);
                if (response != null) {
                    return new ExpiringResponse((Object)response.toString(), response.getExpiration());
                }
                ExpiringResponse er = this.service.getAvailableServices(ctx);
                if (er == null) {
                    throw new LSIDServerException(500, "getAvailableServices should not return null");
                }
                this.cache.writeWSDL(lsid.getAuthority(), lsid, new LSIDWSDLWrapper((String)er.getValue()));
                return er;
            }
            catch (LSIDException e) {
                throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "cache exception in wsdl lookup");
            }
        }
        return this.service.getAvailableServices(ctx);
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
        this.cache = LSIDResolver.getCache();
        if (this.cache == null) {
            throw new LSIDServerException(521, "Unable to load Authority Cache - environmental variable not set");
        }
        if (this.service == null) {
            throw new LSIDServerException(521, "Unable to load Authority Service");
        }
    }

    public void notifyForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        this.service.notifyForeignAuthority(req, authorityName);
    }

    public void revokeNotificationForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        this.service.revokeNotificationForeignAuthority(req, authorityName);
    }
}

