/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class PointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public PointHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.POINT && type != ShapeType.POINTM && type != ShapeType.POINTZ) {
            throw new ShapefileException("PointHandler constructor: expected a type of 1, 11 or 21");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    public PointHandler() {
        this.shapeType = ShapeType.POINT;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getLength(Object geometry) {
        int length;
        if (this.shapeType == ShapeType.POINT) {
            length = 20;
        } else if (this.shapeType == ShapeType.POINTM) {
            length = 28;
        } else if (this.shapeType == ShapeType.POINTZ) {
            length = 36;
        } else {
            throw new IllegalStateException("Expected ShapeType of Point, got" + this.shapeType);
        }
        return length;
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        double z = Double.NaN;
        if (this.shapeType == ShapeType.POINTM) {
            buffer.getDouble();
        }
        if (this.shapeType == ShapeType.POINTZ) {
            z = buffer.getDouble();
        }
        return this.geometryFactory.createPoint(new Coordinate(x, y, z));
    }

    private Object createNull() {
        return this.geometryFactory.createPoint(new Coordinate(Double.NaN, Double.NaN, Double.NaN));
    }

    public void write(ByteBuffer buffer, Object geometry) {
        Coordinate c = ((Point)geometry).getCoordinate();
        buffer.putDouble(c.x);
        buffer.putDouble(c.y);
        if (this.shapeType == ShapeType.POINTZ) {
            if (Double.isNaN(c.z)) {
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(c.z);
            }
        }
        if (this.shapeType == ShapeType.POINTZ || this.shapeType == ShapeType.POINTM) {
            buffer.putDouble(-1.0E41);
        }
    }
}

