/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.FallbackFunction;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.util.logging.Logging;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FunctionFinder {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private Map<String, Class<FunctionExpression>> functionExpressionCache;
    private Map<String, Class<FunctionImpl>> functionImplCache;
    private Map<String, Class<Function>> functionCache;

    public FunctionFinder(Hints hints) {
    }

    public Function findFunction(String name) {
        return this.findFunction(name, null);
    }

    public Function findFunction(String name, List parameters) {
        return this.findFunction(name, parameters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function findFunction(String name, List parameters, Literal fallback) {
        name = this.functionName(name);
        try {
            Object function;
            FunctionFinder functionFinder = this;
            synchronized (functionFinder) {
                if (this.functionExpressionCache == null) {
                    this.functionExpressionCache = new HashMap<String, Class<FunctionExpression>>();
                    this.functionImplCache = new HashMap<String, Class<FunctionImpl>>();
                    this.functionCache = new HashMap<String, Class<Function>>();
                    Set functions = CommonFactoryFinder.getFunctionExpressions(null);
                    for (FunctionExpression function2 : functions) {
                        this.functionExpressionCache.put(function2.getName().toLowerCase(), function2.getClass());
                    }
                    functions = CommonFactoryFinder.getFunctions(null);
                    for (FunctionExpression function2 : functions) {
                        String functionName = function2.getName().toLowerCase();
                        Class<?> functionImplementation = function2.getClass();
                        if (function2 instanceof FunctionImpl) {
                            this.functionImplCache.put(functionName, functionImplementation);
                            continue;
                        }
                        if (function2 instanceof FunctionExpression) {
                            if (this.functionExpressionCache.containsKey(functionName)) continue;
                            this.functionExpressionCache.put(functionName, functionImplementation);
                            continue;
                        }
                        this.functionCache.put(functionName, functionImplementation);
                    }
                }
            }
            Class<Object> clazz = this.functionExpressionCache.get(name.toLowerCase());
            if (clazz != null) {
                function = clazz.newInstance();
                if (parameters != null) {
                    function.setParameters(parameters);
                }
                if (fallback != null && function instanceof ClassificationFunction) {
                    ClassificationFunction classification = (ClassificationFunction)function;
                    classification.setFallbackValue(fallback);
                }
                return function;
            }
            clazz = this.functionImplCache.get(name.toLowerCase());
            if (clazz != null) {
                function = (FunctionImpl)clazz.newInstance();
                if (parameters != null) {
                    ((FunctionImpl)function).setParameters(parameters);
                }
                if (fallback != null) {
                    ((FunctionImpl)function).setFallbackValue(fallback);
                }
                return function;
            }
            if (this.functionCache.containsKey(name.toLowerCase())) {
                Class<Function> functionClass = this.functionCache.get(name.toLowerCase());
                Constructor<Function> constructor = functionClass.getConstructor(List.class, Literal.class);
                return constructor.newInstance(parameters, fallback);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Unable to create class " + name + "Function", e);
            if (fallback != null) {
                return new FallbackFunction(name, parameters, fallback);
            }
            throw new RuntimeException("Unable to create class " + name + "Function", e);
        }
        if (fallback != null) {
            return new FallbackFunction(name, parameters, fallback);
        }
        throw new RuntimeException("Unable to find function " + name);
    }

    private String functionName(String name) {
        int index = -1;
        index = name.indexOf("Function");
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.toLowerCase().trim();
        char c = name.charAt(0);
        name = name.replaceFirst("" + c, "" + Character.toUpperCase(c));
        return name;
    }
}

