/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path.eval;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.eval.PathEval;
import com.hp.hpl.jena.sparql.path.eval.PathEvaluator;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.graph.GraphContainerUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import com.hp.hpl.jena.sparql.vocabulary.ListPFunction;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;

public abstract class PathEngine {
    private final boolean doingRDFSmember;
    private final boolean doingListMember;
    private final Graph graph;
    private final Context context;
    private final PropertyFunctionRegistry registry;
    protected static Transform<Triple, Node> selectSubject = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getSubject();
        }
    };
    protected static Transform<Triple, Node> selectPredicate = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getPredicate();
        }
    };
    protected static Transform<Triple, Node> selectObject = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getObject();
        }
    };
    private static Binding binding = BindingFactory.binding();
    private static Node RDFSmember = RDFS.Nodes.member;
    private static Node ListMember = ListPFunction.nListMember;

    protected PathEngine(Graph graph, Context context) {
        boolean doingRDFSmember$ = false;
        boolean doingListMember$ = false;
        PropertyFunctionRegistry registry$ = null;
        if ((context == null || context.isTrueOrUndef(ARQ.propertyFunctions)) && (registry$ = PropertyFunctionRegistry.chooseRegistry(context)) != null) {
            doingRDFSmember$ = registry$.get(RDFSmember.getURI()) != null;
            doingRDFSmember$ = registry$.get(ListMember.getURI()) != null;
        }
        this.registry = registry$;
        this.doingRDFSmember = doingRDFSmember$;
        this.doingListMember = doingListMember$;
        this.graph = graph;
        this.context = context;
    }

    protected final Iter<Node> eval(Path path, Node node) {
        return PathEval.eval$(this.graph, node, path, this);
    }

    protected final void eval(Path path, Node node, Collection<Node> output) {
        PathEval.eval$(this.graph, node, path, this, output);
    }

    protected abstract void flipDirection();

    protected abstract boolean direction();

    protected abstract Collection<Node> collector();

    protected final Iterator<Node> doOne(Node node, Node property) {
        Iter<Node> iter2 = null;
        if (this.direction()) {
            Iter<Triple> iter1 = Iter.iter(this.graphFind(node, property, Node.ANY));
            iter2 = iter1.map(selectObject);
        } else {
            Iter<Triple> iter1 = Iter.iter(this.graphFind(Node.ANY, property, node));
            iter2 = iter1.map(selectSubject);
        }
        return iter2;
    }

    protected abstract void doSeq(Path var1, Path var2, Node var3, Collection<Node> var4);

    protected abstract void doAlt(Path var1, Path var2, Node var3, Collection<Node> var4);

    protected abstract void doZeroOrMore(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doOneOrMore(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doZeroOrOne(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doNegatedPropertySet(P_NegPropSet var1, Node var2, Collection<Node> var3);

    protected void doZeroOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        this.doZeroOrMore(pathStep, node, output);
    }

    protected void doOneOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        this.doOneOrMore(pathStep, node, output);
    }

    protected abstract void doZero(Path var1, Node var2, Collection<Node> var3);

    protected abstract void doFixedLengthPath(Path var1, Node var2, long var3, Collection<Node> var5);

    protected abstract void doMultiLengthPath(Path var1, Node var2, long var3, long var5, Collection<Node> var7);

    protected final void fill(Iterator<Node> iter, Collection<Node> output) {
        while (iter.hasNext()) {
            output.add(iter.next());
        }
    }

    protected static long dec(long x) {
        return x <= 0L ? x : x - 1L;
    }

    protected Iterator<Node> stepExcludeForwards(Node node, List<Node> excludedNodes) {
        Iter<Triple> iter1 = this.forwardLinks(node, excludedNodes);
        Iter<Node> r1 = iter1.map(selectObject);
        return r1;
    }

    protected Iterator<Node> stepExcludeBackwards(Node node, List<Node> excludedNodes) {
        Iter<Triple> iter1 = this.backwardLinks(node, excludedNodes);
        Iter<Node> r1 = iter1.map(selectSubject);
        return r1;
    }

    protected Iter<Triple> forwardLinks(Node x, Collection<Node> excludeProperties) {
        Iter<Triple> iter1 = Iter.iter(this.graphFind(x, Node.ANY, Node.ANY));
        if (excludeProperties != null) {
            iter1 = iter1.filter(new PathEvaluator.FilterExclude(excludeProperties));
        }
        return iter1;
    }

    protected Iter<Triple> backwardLinks(Node x, Collection<Node> excludeProperties) {
        Iter<Triple> iter1 = Iter.iter(this.graphFind(Node.ANY, Node.ANY, x));
        if (excludeProperties != null) {
            iter1 = iter1.filter(new PathEvaluator.FilterExclude(excludeProperties));
        }
        return iter1;
    }

    protected Iterator<Triple> graphFind(Node s, Node p, Node o) {
        return this.graphFind(this.graph, s, p, o, this.context);
    }

    private Iterator<Triple> graphFind(Graph graph, Node s, Node p, Node o, Context context) {
        if (this.doingRDFSmember && RDFSmember.equals((Object)p)) {
            return GraphContainerUtils.rdfsMember(graph, s, o);
        }
        if (this.doingListMember && ListMember.equals((Object)p)) {
            return GraphList.listMember(graph, s, o);
        }
        return this.graphFind2(graph, s, p, o, context);
    }

    private Iterator<Triple> graphFind2(Graph graph, Node s, Node p, Node o, Context context) {
        PropertyFunctionFactory f;
        if (p != null && p.isURI() && this.registry != null && (f = this.registry.get(p.getURI())) != null) {
            return this.graphFindWorker(graph, s, f, p, o, context);
        }
        return graph.find(s, p, o);
    }

    private Iterator<Triple> graphFindWorker(Graph graph, Node s, PropertyFunctionFactory f, Node p, Node o, Context context) {
        PropertyFunction pf = f.create(p.getURI());
        PropFuncArg sv = PathEngine.arg(s, "S");
        PropFuncArg ov = PathEngine.arg(o, "O");
        QueryIterRoot r = QueryIterRoot.create(new ExecutionContext(context, graph, null, null));
        QueryIterator qIter = pf.exec(r, sv, p, ov, new ExecutionContext(ARQ.getContext(), graph, null, null));
        if (!qIter.hasNext()) {
            return Iter.nullIterator();
        }
        ArrayList<Triple> array = new ArrayList<Triple>();
        while (qIter.hasNext()) {
            Binding b = (Binding)qIter.next();
            Node st = PathEngine.value(sv, b);
            Node ot = PathEngine.value(ov, b);
            array.add(Triple.create((Node)st, (Node)p, (Node)ot));
        }
        return array.iterator();
    }

    private static PropFuncArg arg(Node x, String name) {
        if (x == null || Node.ANY.equals((Object)x)) {
            return new PropFuncArg((Node)Var.alloc(name));
        }
        return new PropFuncArg(x);
    }

    private static Node value(PropFuncArg arg, Binding b) {
        Node x = arg.getArg();
        if (!Var.isVar(x)) {
            return x;
        }
        return b.get(Var.alloc(x));
    }
}

