/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;

public class SQLDatabase {
    ConnectionPool connectionPool;

    public SQLDatabase(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public SQLDatabase() {
    }

    public Connection getConnection() {
        return (Connection)this.getConnectionPool().pop();
    }

    public void releaseConnection(Connection c) {
        boolean skipIt = false;
        try {
            skipIt = c.isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!skipIt) {
            this.getConnectionPool().push(c);
        }
    }

    protected void destroyConnection(Connection c) {
        this.getConnectionPool().realDestroy(c);
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }
}

