/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ClassModel {
    static final Comparator<Method> methodSorter = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            return o1.toGenericString().compareTo(o2.toGenericString());
        }
    };
    static final Comparator<Field> fieldSorter = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.toGenericString().compareTo(o2.toGenericString());
        }
    };
    private final LinkedHashMap<Method, MethodModel> methods;
    private final LinkedHashMap<Field, FieldModel> fields;

    public ClassModel(Class<?> clazz) {
        this.methods = ClassModel.methodsModel(clazz);
        this.fields = ClassModel.fieldsModel(clazz);
    }

    private static LinkedHashMap<Method, MethodModel> methodsModel(Class<?> clazz) {
        return new ModelBuilder<Method, MethodModel>(){

            protected Method[] members(Class<?> c) {
                Method[] declaredMethods = c.getDeclaredMethods();
                Arrays.sort(declaredMethods, methodSorter);
                return declaredMethods;
            }

            @Override
            protected MethodModel model(Method t) {
                return new MethodModel(t);
            }
        }.build(clazz);
    }

    private static LinkedHashMap<Field, FieldModel> fieldsModel(Class<?> clazz) {
        return new ModelBuilder<Field, FieldModel>(){

            protected Field[] members(Class<?> c) {
                Field[] declaredFields = c.getDeclaredFields();
                Arrays.sort(declaredFields, fieldSorter);
                return declaredFields;
            }

            @Override
            protected FieldModel model(Field t) {
                return new FieldModel(t);
            }
        }.build(clazz);
    }

    public Map<Method, MethodModel> getMethods() {
        return Collections.unmodifiableMap(this.methods);
    }

    public Map<Field, FieldModel> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public Map<Method, MethodModel> getAnnotatedLeafMethods(Class<? extends Annotation> annotation) {
        LinkedHashMap<Method, MethodModel> result = new LinkedHashMap<Method, MethodModel>();
        block0: for (Map.Entry<Method, MethodModel> e : this.getMethods().entrySet()) {
            MethodModel mm = e.getValue();
            if (!((Method)mm.element).isAnnotationPresent(annotation)) continue;
            for (mm = (MethodModel)mm.getDown(); mm != null; mm = (MethodModel)mm.getDown()) {
                if (((Method)mm.element).isAnnotationPresent(annotation)) continue block0;
            }
            result.put(e.getKey(), e.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public <T extends Annotation> T getAnnotation(Method method, Class<T> annClass, boolean inherited) {
        MethodModel methodModel = this.methods.get(method);
        if (methodModel == null) {
            throw new IllegalArgumentException("No model for method: " + methodModel);
        }
        if (inherited) {
            while (methodModel != null) {
                T annValue = ((Method)methodModel.element).getAnnotation(annClass);
                if (annValue != null) {
                    return annValue;
                }
                methodModel = (MethodModel)methodModel.getUp();
            }
            return null;
        }
        return method.getAnnotation(annClass);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Method method, Class<T> annClass, boolean inherited) {
        return this.getAnnotation(method, annClass, inherited) != null;
    }

    public static final class FieldModel
    extends ClassElement<Field, FieldModel> {
        public FieldModel(Field f) {
            super(f);
        }

        public String toString() {
            return ((Field)this.element).getDeclaringClass().getSimpleName() + "." + ((Field)this.element).getName();
        }

        @Override
        boolean overridesOrShadows(ClassElement<Field, FieldModel> sub) {
            Field f1 = (Field)this.element;
            Field f2 = (Field)sub.element;
            if (!f1.getName().equals(f2.getName())) {
                return false;
            }
            Package package1 = f1.getDeclaringClass().getPackage();
            Package package2 = f1.getDeclaringClass().getPackage();
            if (this.getAccessScope() == Scope.PACKAGE) {
                return package1.equals(package2);
            }
            return true;
        }

        public int hashCode() {
            return ((Field)this.element).getName().hashCode();
        }

        public boolean equals(Object obj) {
            FieldModel other = (FieldModel)obj;
            return ((Field)this.element).getName().equals(((Field)other.element).getName());
        }
    }

    public static final class MethodModel
    extends ClassElement<Method, MethodModel> {
        public MethodModel(Method m) {
            super(m);
        }

        public String toString() {
            return ((Method)this.element).getDeclaringClass().getSimpleName() + "." + ((Method)this.element).getName();
        }

        @Override
        boolean overridesOrShadows(ClassElement<Method, MethodModel> sub) {
            Method m1 = (Method)this.element;
            Method m2 = (Method)sub.element;
            if (!m1.getName().equals(m2.getName())) {
                return false;
            }
            if (!Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes())) {
                return false;
            }
            Package package1 = m1.getDeclaringClass().getPackage();
            Package package2 = m2.getDeclaringClass().getPackage();
            if (this.getAccessScope() == Scope.PACKAGE) {
                return package1.equals(package2);
            }
            return true;
        }

        public int hashCode() {
            int hashCode = ((Method)this.element).getName().hashCode();
            for (Class<?> c : ((Method)this.element).getParameterTypes()) {
                hashCode += 31 * c.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            MethodModel other = (MethodModel)obj;
            return ((Method)this.element).getName().equals(((Method)other.element).getName()) && Arrays.equals(((Method)this.element).getParameterTypes(), ((Method)other.element).getParameterTypes());
        }
    }

    private static abstract class ModelBuilder<T_MEMBER extends Member, T_MODEL extends ClassElement<T_MEMBER, T_MODEL>> {
        private ModelBuilder() {
        }

        final LinkedHashMap<T_MEMBER, T_MODEL> build(Class<?> clazz) {
            LinkedHashMap<Member, T_MODEL> elements = new LinkedHashMap<Member, T_MODEL>();
            HashMap tops = new HashMap();
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                for (Member m : this.members(c)) {
                    T_MODEL model = this.model(m);
                    if (elements.put(m, model) != null) {
                        throw new RuntimeException("Class element should not have duplicates in superclasses: " + m);
                    }
                    if (((ClassElement)model).getAccessScope() == Scope.PRIVATE) continue;
                    ArrayList<T_MODEL> list = (ArrayList<T_MODEL>)tops.get(model);
                    if (list == null) {
                        list = new ArrayList<T_MODEL>();
                        tops.put(model, list);
                    }
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        ClassElement sub = (ClassElement)i.next();
                        if (!((ClassElement)model).overridesOrShadows(sub)) continue;
                        i.remove();
                        sub.setUp(model);
                        ((ClassElement)model).setDown((ClassElement)sub);
                    }
                    list.add(model);
                }
            }
            return elements;
        }

        protected abstract T_MEMBER[] members(Class<?> var1);

        protected abstract T_MODEL model(T_MEMBER var1);
    }

    static abstract class ClassElement<T extends Member, E extends ClassElement<T, E>> {
        private final int modifiers;
        private final Scope scope;
        public final T element;
        private E up;
        private E down;

        public ClassElement(T element) {
            this.element = element;
            this.modifiers = element.getModifiers();
            this.scope = ClassElement.getAccessScope(this.modifiers);
        }

        private static Scope getAccessScope(int modifiers) {
            if (Modifier.isPublic(modifiers)) {
                return Scope.PUBLIC;
            }
            if (Modifier.isProtected(modifiers)) {
                return Scope.PROTECTED;
            }
            if (Modifier.isPrivate(modifiers)) {
                return Scope.PRIVATE;
            }
            return Scope.PACKAGE;
        }

        void setDown(E down) {
            assert (this.down == null);
            this.down = down;
        }

        void setUp(E up) {
            assert (this.up == null);
            this.up = up;
        }

        public E getDown() {
            return this.down;
        }

        public E getUp() {
            return this.up;
        }

        public Scope getAccessScope() {
            return this.scope;
        }

        abstract boolean overridesOrShadows(ClassElement<T, E> var1);
    }

    public static enum Scope {
        PUBLIC,
        PROTECTED,
        PACKAGE,
        PRIVATE;

    }
}

