/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.tika.config.Field;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.utils.CharsetUtils;

public class Icu4jEncodingDetector
implements EncodingDetector {
    @Field
    private boolean stripMarkup = false;
    @Field
    private int markLimit = 12000;

    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        String cleaned;
        MediaType mt;
        if (input == null) {
            return null;
        }
        CharsetDetector detector = new CharsetDetector(this.markLimit);
        String incomingCharset = metadata.get("Content-Encoding");
        String incomingType = metadata.get("Content-Type");
        if (incomingCharset == null && incomingType != null && (mt = MediaType.parse((String)incomingType)) != null) {
            incomingCharset = (String)mt.getParameters().get("charset");
        }
        if (incomingCharset != null && (cleaned = CharsetUtils.clean((String)incomingCharset)) != null) {
            detector.setDeclaredEncoding(cleaned);
        }
        detector.enableInputFilter(true);
        detector.setText(input);
        for (CharsetMatch match : detector.detectAll()) {
            try {
                return CharsetUtils.forName((String)match.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    @Field
    public void setStripMarkup(boolean stripMarkup) {
        this.stripMarkup = stripMarkup;
    }

    public boolean getStripMarkup() {
        return this.stripMarkup;
    }

    @Field
    public void setMarkLimit(int markLimit) {
        this.markLimit = markLimit;
    }

    public int getMarkLimit() {
        return this.markLimit;
    }
}

