/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import org.apache.wicket.protocol.http.AbstractRequestLogger;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger
extends AbstractRequestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLogger.class);

    @Override
    protected void log(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        if (LOG.isInfoEnabled()) {
            LOG.info(this.createRequestData(rd, sd));
        }
    }

    private String createRequestData(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        AppendingStringBuffer sb = new AppendingStringBuffer(150);
        sb.append("startTime=\"");
        sb.append(this.formatDate(rd.getStartDate()));
        sb.append("\",duration=");
        sb.append((Object)rd.getTimeTaken());
        sb.append(",url=\"");
        sb.append(rd.getRequestedUrl());
        sb.append('\"');
        sb.append(",event={");
        sb.append(this.getRequestHandlerString(rd.getEventTarget()));
        sb.append("},response={");
        sb.append(this.getRequestHandlerString(rd.getResponseTarget()));
        sb.append("},sessionid=\"");
        sb.append(rd.getSessionId());
        sb.append('\"');
        sb.append(",sessionsize=");
        sb.append((Object)rd.getSessionSize());
        if (rd.getSessionInfo() != null && !Strings.isEmpty((CharSequence)rd.getSessionInfo().toString())) {
            sb.append(",sessioninfo={");
            sb.append(rd.getSessionInfo());
            sb.append('}');
        }
        if (sd != null) {
            sb.append(",sessionstart=\"");
            sb.append(this.formatDate(sd.getStartDate()));
            sb.append("\",requests=");
            sb.append(sd.getNumberOfRequests());
            sb.append(",totaltime=");
            sb.append(sd.getTotalTimeTaken());
        }
        sb.append(",activerequests=");
        sb.append(rd.getActiveRequest());
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory() / 1000000L;
        long total = runtime.totalMemory() / 1000000L;
        long used = total - runtime.freeMemory() / 1000000L;
        sb.append(",maxmem=");
        sb.append(max);
        sb.append("M,total=");
        sb.append(total);
        sb.append("M,used=");
        sb.append(used);
        sb.append('M');
        return sb.toString();
    }

    private String getRequestHandlerString(IRequestHandler handler) {
        AppendingStringBuffer sb = new AppendingStringBuffer(128);
        if (handler != null) {
            Class<?> handlerClass = handler.getClass();
            sb.append("handler=");
            sb.append(handlerClass.isAnonymousClass() ? handlerClass.getName() : Classes.simpleName(handlerClass));
            if (handler instanceof ILoggableRequestHandler) {
                sb.append(",data=");
                sb.append((Object)((ILoggableRequestHandler)handler).getLogData());
            }
        } else {
            sb.append("none");
        }
        return sb.toString();
    }
}

