/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.util.HashMap;
import java.util.Map;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public abstract class SVNClientAdapterFactory {
    private static Map ourFactoriesMap;
    private static SVNClientAdapterFactory preferredFactory;

    protected abstract ISVNClientAdapter createSVNClientImpl();

    protected abstract String getClientType();

    public static ISVNClientAdapter createSVNClient(String string) {
        if (ourFactoriesMap == null || !ourFactoriesMap.containsKey(string)) {
            return null;
        }
        SVNClientAdapterFactory sVNClientAdapterFactory = (SVNClientAdapterFactory)ourFactoriesMap.get(string);
        if (sVNClientAdapterFactory != null) {
            return sVNClientAdapterFactory.createSVNClientImpl();
        }
        return null;
    }

    public static boolean isSVNClientAvailable(String string) {
        return ourFactoriesMap != null && ourFactoriesMap.containsKey(string);
    }

    public static String getPreferredSVNClientType() throws SVNClientException {
        if (preferredFactory != null) {
            return preferredFactory.getClientType();
        }
        throw new SVNClientException("No subversion client interface found.");
    }

    protected static void registerAdapterFactory(SVNClientAdapterFactory sVNClientAdapterFactory) throws SVNClientException {
        String string;
        if (sVNClientAdapterFactory == null) {
            return;
        }
        if (ourFactoriesMap == null) {
            ourFactoriesMap = new HashMap();
        }
        if (!ourFactoriesMap.containsKey(string = sVNClientAdapterFactory.getClientType())) {
            ourFactoriesMap.put(string, sVNClientAdapterFactory);
            if (preferredFactory == null) {
                preferredFactory = sVNClientAdapterFactory;
            }
        } else {
            throw new SVNClientException("factory for type " + string + " already registered");
        }
    }
}

