/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.dao.MetacatDataSourceFactory;
import org.dataone.cn.dao.ReplicationDao;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class ReplicationDaoMetacatImpl
implements ReplicationDao {
    private static final Log log = LogFactory.getLog(ReplicationDaoMetacatImpl.class);
    private static final String cnNodeId = Settings.getConfiguration().getString("cn.router.nodeId", "urn:node:CN");
    private JdbcTemplate jdbcTemplate;
    private final FastDateFormat format = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private int failureWindow = 3600;

    public ReplicationDaoMetacatImpl() {
        this.jdbcTemplate = new JdbcTemplate((DataSource)MetacatDataSourceFactory.getMetacatDataSource());
        this.failureWindow = Settings.getConfiguration().getInt("replication.failure.query.window", this.failureWindow);
    }

    @Override
    public Collection<NodeReference> getMemberNodesWithQueuedReplica() throws DataAccessException {
        List<Object> results = new ArrayList<NodeReference>();
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT         DISTINCT member_node        FROM smreplicationstatus    WHERE status='QUEUED';     ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    log.debug((Object)("getMemberNodesWithQueuedReplica statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new NodeReferenceMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return results;
    }

    @Override
    public int getQueuedReplicaCountByNode(final String nodeId) throws DataAccessException {
        int count = 0;
        List counts = new ArrayList();
        try {
            counts = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT        count(*)                               FROM  smreplicationstatus              WHERE member_node = ?                  AND status = 'QUEUED';             ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setString(1, nodeId);
                    log.debug((Object)("getQueuedReplicaCountByNode statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new CountResultMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        if (counts.size() > 0) {
            count = (Integer)counts.get(0);
        }
        return count;
    }

    @Override
    public Collection<ReplicationDao.ReplicaDto> getQueuedReplicasByNode(final String mnId) throws DataAccessException {
        List<ReplicationDao.ReplicaDto> results = new ArrayList<ReplicationDao.ReplicaDto>();
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT        guid,                                  member_node,                           status,                                date_verified                          FROM  smreplicationstatus              WHERE member_node = ?               AND status = 'QUEUED'               ORDER BY date_verified ASC;          ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setString(1, mnId);
                    log.debug((Object)("getQueuedReplicasByDate statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new ReplicaResultMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return results;
    }

    @Override
    public boolean queuedReplicaExists(final String identifier, final String nodeId) throws DataAccessException {
        List counts = new ArrayList();
        try {
            counts = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT        count(*)                               FROM  smreplicationstatus              WHERE guid = ?                         AND member_node = ?                    AND status = 'QUEUED'                ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setString(1, identifier);
                    statement.setString(2, nodeId);
                    log.debug((Object)("getQueuedReplicasByDate statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new CountResultMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return counts.size() > 0 && counts.get(0) != null && (Integer)counts.get(0) > 0;
    }

    @Override
    public List<Identifier> getInvalidMemberNodeReplicasByDate(Date auditDate, int pageNumber, int pageSize) throws DataAccessException {
        List<Object> results = new ArrayList<Identifier>();
        final Timestamp timestamp = new Timestamp(auditDate.getTime());
        if (pageSize < 1) {
            pageNumber = 0;
        }
        final int finalPageNumber = pageNumber;
        final int finalPageSize = pageSize;
        final int offset = (pageNumber - 1) * pageSize;
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT DISTINCT guid, date_verified  FROM  smreplicationstatus  WHERE date_verified <= ?   AND status = 'INVALIDATED'   AND member_node <> '" + cnNodeId + "'  ORDER BY date_verified ASC ";
                    if (finalPageSize > 0 && finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " LIMIT " + finalPageSize;
                    }
                    if (finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " OFFSET " + offset;
                    }
                    sqlStatement = sqlStatement + ";";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setTimestamp(1, timestamp);
                    log.debug((Object)("getInvalidMemberNodeReplicas statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new IdentifierMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return results;
    }

    @Override
    public List<Identifier> getCompletedMemberNodeReplicasByDate(Date auditDate, int pageNumber, int pageSize) throws DataAccessException {
        List<Object> results = new ArrayList<Identifier>();
        final Timestamp timestamp = new Timestamp(auditDate.getTime());
        if (pageSize < 1) {
            pageNumber = 0;
        }
        final int finalPageNumber = pageNumber;
        final int finalPageSize = pageSize;
        final int offset = (pageNumber - 1) * pageSize;
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT DISTINCT guid, date_verified  FROM  smreplicationstatus  WHERE date_verified <= ?   AND status = 'COMPLETED'   AND member_node <> '" + cnNodeId + "'  ORDER BY date_verified ASC ";
                    if (finalPageSize > 0 && finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " LIMIT " + finalPageSize;
                    }
                    if (finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " OFFSET " + offset;
                    }
                    sqlStatement = sqlStatement + ";";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setTimestamp(1, timestamp);
                    log.debug((Object)("getCompletedMemberNodeReplicas statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new IdentifierMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return results;
    }

    @Override
    public List<Identifier> getCompletedCoordinatingNodeReplicasByDate(Date auditDate, int pageNumber, int pageSize) throws DataAccessException {
        List<Object> results = new ArrayList<Identifier>();
        final Timestamp timestamp = new Timestamp(auditDate.getTime());
        if (pageSize < 1) {
            pageNumber = 0;
        }
        final int finalPageNumber = pageNumber;
        final int finalPageSize = pageSize;
        final int offset = (pageNumber - 1) * pageSize;
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT DISTINCT guid, date_verified  FROM  smreplicationstatus  WHERE date_verified <= ?   AND status = 'COMPLETED'   AND member_node = '" + cnNodeId + "'  ORDER BY date_verified ASC";
                    if (finalPageSize > 0 && finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " LIMIT " + finalPageSize;
                    }
                    if (finalPageNumber > 0) {
                        sqlStatement = sqlStatement + " OFFSET " + offset;
                    }
                    sqlStatement = sqlStatement + ";";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setTimestamp(1, timestamp);
                    log.debug((Object)("getCompletedCoordinatingNodeReplicas statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new IdentifierMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return results;
    }

    @Override
    public List<ReplicationDao.ReplicaDto> getRequestedReplicasByDate(Date cutoffDate) throws DataAccessException {
        final Timestamp timestamp = new Timestamp(cutoffDate.getTime());
        List<ReplicationDao.ReplicaDto> results = new ArrayList<ReplicationDao.ReplicaDto>();
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT        guid,                                  member_node,                           status,                                date_verified                          FROM  smreplicationstatus              WHERE date_verified <= ?               AND status = 'REQUESTED'               ORDER BY date_verified ASC;          ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setTimestamp(1, timestamp);
                    log.debug((Object)("getRequestedReplicasByDate statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new ReplicaResultMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        return results;
    }

    @Override
    public int getRequestedReplicationCount(NodeReference nodeRef) throws DataAccessException {
        int count = 0;
        final String nodeId = nodeRef.getValue();
        List counts = new ArrayList();
        try {
            counts = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT        count(*)                                  FROM  smreplicationstatus              WHERE member_node = ?                  AND status = 'REQUESTED';             ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setString(1, nodeId);
                    log.debug((Object)("getRequestedReplicasByDate statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new CountResultMapper());
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        if (counts.size() > 0) {
            count = (Integer)counts.get(0);
        }
        return count;
    }

    @Override
    public Map<NodeReference, Integer> getPendingReplicasByNode() throws DataAccessException {
        log.debug((Object)"Getting current pending replicas by node.");
        HashMap<NodeReference, Integer> pendingReplicasByNodeMap = new HashMap<NodeReference, Integer>();
        List results = null;
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT           member_node,                  count(status) AS count       FROM  smreplicationstatus    WHERE status = 'REQUESTED'     OR  status = 'QUEUED'      GROUP BY member_node         ORDER BY member_node;      ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    log.debug((Object)("getPendingReplicasbyNode statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new ReplicaCountMap());
            log.debug((Object)("Pending replicas by node result size is " + results.size()));
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        this.consolidateResultsIntoSingleMap(pendingReplicasByNodeMap, results);
        if (log.isDebugEnabled()) {
            Iterator iterator = pendingReplicasByNodeMap.entrySet().iterator();
            log.debug((Object)"Pending replica map by node: ");
            while (iterator.hasNext()) {
                Map.Entry pairs = iterator.next();
                log.debug((Object)("Node: " + ((NodeReference)pairs.getKey()).getValue() + ", count: " + (Integer)pairs.getValue()));
            }
        }
        return pendingReplicasByNodeMap;
    }

    @Override
    public Map<NodeReference, Integer> getRecentFailedReplicas() throws DataAccessException {
        log.debug((Object)"Getting recently failed replicas by node.");
        HashMap<NodeReference, Integer> recentFailedReplicasByNodeMap = new HashMap<NodeReference, Integer>();
        List results = null;
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    Timestamp cutoffDate = ReplicationDaoMetacatImpl.this.generateStatusCutoffDate();
                    String sqlStatement = "SELECT                   member_node,                           count(status) AS count                 FROM  smreplicationstatus  WHERE status = 'FAILED'                AND   date_verified >= ?               GROUP BY member_node                   ORDER BY member_node;                ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setTimestamp(1, cutoffDate);
                    log.debug((Object)("getRecentFailedReplicas statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new ReplicaCountMap());
            log.debug((Object)("Failed replicas by node result size is " + results.size()));
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        this.consolidateResultsIntoSingleMap(recentFailedReplicasByNodeMap, results);
        if (log.isDebugEnabled()) {
            Iterator iterator = recentFailedReplicasByNodeMap.entrySet().iterator();
            log.debug((Object)"Recent failed replica map by node: ");
            while (iterator.hasNext()) {
                Map.Entry pairs = iterator.next();
                log.debug((Object)("Node: " + ((NodeReference)pairs.getKey()).getValue() + ", count: " + (Integer)pairs.getValue()));
            }
        }
        return recentFailedReplicasByNodeMap;
    }

    @Override
    public Map<NodeReference, Integer> getRecentCompletedReplicas() throws DataAccessException {
        log.debug((Object)"Getting recently completed replicas by node.");
        HashMap<NodeReference, Integer> recentCompletedReplicasByNodeMap = new HashMap<NodeReference, Integer>();
        List results = null;
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    Timestamp cutoffDate = ReplicationDaoMetacatImpl.this.generateStatusCutoffDate();
                    String sqlStatement = "SELECT                   member_node,                           count(status) AS count                 FROM  smreplicationstatus  WHERE status = 'COMPLETED'             AND   date_verified >= ?               GROUP BY member_node                   ORDER BY member_node;                ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    statement.setTimestamp(1, cutoffDate);
                    log.debug((Object)("getRecentCompletedReplicas statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new ReplicaCountMap());
            log.debug((Object)("Recent completed replicas by node result size is " + results.size()));
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        this.consolidateResultsIntoSingleMap(recentCompletedReplicasByNodeMap, results);
        if (log.isDebugEnabled()) {
            Iterator iterator = recentCompletedReplicasByNodeMap.entrySet().iterator();
            log.debug((Object)"Recent completed replica map by node: ");
            while (iterator.hasNext()) {
                Map.Entry pairs = iterator.next();
                log.debug((Object)("Node: " + ((NodeReference)pairs.getKey()).getValue() + ", count: " + (Integer)pairs.getValue()));
            }
        }
        return recentCompletedReplicasByNodeMap;
    }

    private void handleJdbcDataAccessException(org.springframework.dao.DataAccessException dae) throws DataAccessException {
        log.error((Object)("Jdbc Data access exception occurred: " + dae.getRootCause().getMessage()));
        dae.printStackTrace();
        throw dae;
    }

    private void consolidateResultsIntoSingleMap(Map<NodeReference, Integer> replicasByNodeMap, List<Map<NodeReference, Integer>> results) {
        for (Map<NodeReference, Integer> result : results) {
            replicasByNodeMap.putAll(result);
        }
    }

    private Timestamp generateStatusCutoffDate() {
        Calendar cal = Calendar.getInstance();
        log.debug((Object)("Calendar date is: " + this.format.format(cal)));
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(13, -this.failureWindow);
        Timestamp cutoffDate = new Timestamp(cal.getTimeInMillis());
        log.debug((Object)("Cutoff date is: " + cutoffDate.toString()));
        return cutoffDate;
    }

    @Override
    public Map<String, Integer> getCountsByNodeStatus() throws DataAccessException {
        log.debug((Object)"Getting current entry counts by node status.");
        HashMap<String, Integer> replicaCountsByNodeStatus = new HashMap<String, Integer>();
        List results = null;
        try {
            results = this.jdbcTemplate.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                    String sqlStatement = "SELECT                   member_node, status,                 count(status) AS count                FROM  smreplicationstatus             GROUP BY member_node, status          ORDER BY member_node, status;       ";
                    PreparedStatement statement = conn.prepareStatement(sqlStatement);
                    log.debug((Object)("getCountsByNodeStatus statement is: " + statement));
                    return statement;
                }
            }, (RowMapper)new CountsByNodeStatusMap());
            log.debug((Object)("Counts by node-status result size is " + results.size()));
        }
        catch (org.springframework.dao.DataAccessException dae) {
            this.handleJdbcDataAccessException(dae);
        }
        for (Map result : results) {
            replicaCountsByNodeStatus.putAll(result);
        }
        return replicaCountsByNodeStatus;
    }

    private static final class NodeReferenceMapper
    implements RowMapper<NodeReference> {
        private NodeReferenceMapper() {
        }

        public NodeReference mapRow(ResultSet rs, int rowNum) throws SQLException {
            NodeReference nodeRef = new NodeReference();
            nodeRef.setValue(rs.getString("member_node"));
            return nodeRef;
        }
    }

    private static final class ReplicaResultMapper
    implements RowMapper<ReplicationDao.ReplicaDto> {
        private ReplicaResultMapper() {
        }

        public ReplicationDao.ReplicaDto mapRow(ResultSet rs, int rowNum) throws SQLException {
            ReplicationDao.ReplicaDto result = new ReplicationDao.ReplicaDto();
            Identifier pid = new Identifier();
            pid.setValue(rs.getString("guid"));
            result.identifier = pid;
            Replica replica = new Replica();
            NodeReference nodeRef = new NodeReference();
            nodeRef.setValue(rs.getString("member_node"));
            replica.setReplicaMemberNode(nodeRef);
            ReplicationStatus status = ReplicationStatus.convert((String)StringUtils.lowerCase((String)rs.getString("status")));
            replica.setReplicationStatus(status);
            Timestamp verifiedDate = rs.getTimestamp("date_verified");
            replica.setReplicaVerified((Date)verifiedDate);
            result.replica = replica;
            return result;
        }
    }

    private static final class IdentifierMapper
    implements RowMapper<Identifier> {
        private IdentifierMapper() {
        }

        public Identifier mapRow(ResultSet rs, int rowNum) throws SQLException {
            Identifier pid = new Identifier();
            pid.setValue(rs.getString("guid"));
            return pid;
        }
    }

    private static final class CountResultMapper
    implements RowMapper<Integer> {
        private CountResultMapper() {
        }

        public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getInt(1);
        }
    }

    private static final class CountsByNodeStatusMap
    implements RowMapper<Map<String, Integer>> {
        private CountsByNodeStatusMap() {
        }

        public Map<String, Integer> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            HashMap<String, Integer> countsByNodeStatusMap = new HashMap<String, Integer>();
            String memberNode = resultSet.getString("member_node");
            String status = resultSet.getString("status");
            Integer count = resultSet.getInt("count");
            countsByNodeStatusMap.put(memberNode + "-" + status, count);
            return countsByNodeStatusMap;
        }
    }

    private static final class PendingReplicaMapper
    implements RowMapper<Map<Identifier, NodeReference>> {
        private PendingReplicaMapper() {
        }

        public Map<Identifier, NodeReference> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            HashMap<Identifier, NodeReference> pendingReplicasByNode = new HashMap<Identifier, NodeReference>();
            String identifier = resultSet.getString("guid");
            Identifier pid = new Identifier();
            pid.setValue(identifier);
            String memberNode = resultSet.getString("member_node");
            NodeReference nodeId = new NodeReference();
            nodeId.setValue(memberNode);
            log.debug((Object)("Adding pending replica request for removal: " + identifier + " at " + memberNode));
            pendingReplicasByNode.put(pid, nodeId);
            return pendingReplicasByNode;
        }
    }

    private static final class ReplicaCountMap
    implements RowMapper<Map<NodeReference, Integer>> {
        private ReplicaCountMap() {
        }

        public Map<NodeReference, Integer> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            HashMap<NodeReference, Integer> replicaCountByNodeMap = new HashMap<NodeReference, Integer>();
            NodeReference nodeId = new NodeReference();
            nodeId.setValue(resultSet.getString("member_node"));
            Integer count = resultSet.getInt("count");
            replicaCountByNodeMap.put(nodeId, count);
            return replicaCountByNodeMap;
        }
    }
}

