/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdfxml.xmlinput;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.rdfxml.xmlinput.JenaHandler;
import com.hp.hpl.jena.rdfxml.xmlinput.JenaReader;
import com.hp.hpl.jena.rdfxml.xmlinput.SAX2RDF;
import com.hp.hpl.jena.shared.JenaException;
import org.xml.sax.SAXParseException;

public class SAX2Model
extends SAX2RDF {
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private final JenaHandler handler;
    private boolean closed = false;

    public static SAX2Model create(String base, Model m) throws SAXParseException {
        return new SAX2Model(base, m, "");
    }

    public static SAX2Model create(String base, Model m, String lang) throws SAXParseException {
        return new SAX2Model(base, m, lang);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXParseException {
        super.startPrefixMapping(prefix, uri);
    }

    protected SAX2Model(String base, Model m, String lang) throws SAXParseException {
        super(base, lang);
        this.handler = this.initHandler(m);
    }

    private JenaHandler initHandler(Model m) {
        if (m == null) {
            return null;
        }
        JenaHandler rslt = new JenaHandler(m, this.errorHandler);
        rslt.useWith(this.getHandlers());
        return rslt;
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        if (this.handler != null) {
            this.handler.setErrorHandler(errHandler);
        }
        return old;
    }

    public Object setProperty(String str, Object value) throws JenaException {
        Object obj = value;
        if (str.startsWith("http:") && str.startsWith("http://jena.hpl.hp.com/arp/properties/")) {
            str = str.substring(JenaReader.arpPropertiesURLLength);
        }
        return this.setArpProperty(str, obj);
    }

    private Object setArpProperty(String str, Object v) {
        return JenaReader.processArpOptions(this.getOptions(), str, v, this.errorHandler);
    }
}

