/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.generator;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.cn.index.generator.filter.HZEventFilter;
import org.dataone.cn.index.task.IgnoringIndexIdPool;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.task.IndexTaskRepository;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.service.types.v2.SystemMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;

public class IndexTaskGenerator {
    private static Logger logger = Logger.getLogger((String)IndexTaskGenerator.class.getName());
    private static PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private static HZEventFilter filter = new HZEventFilter();
    @Autowired
    private IndexTaskRepository repo;

    public IndexTask processSystemMetaDataAdd(SystemMetadata smd, String objectPath) {
        if (IgnoringIndexIdPool.isNotIgnorePid((SystemMetadata)smd) && !filter.filter(smd)) {
            long start = System.currentTimeMillis();
            this.removeDuplicateNewTasks(smd);
            IndexTask task = new IndexTask(smd, objectPath);
            task.setAddPriority();
            task = (IndexTask)this.repo.save((Object)task);
            String id = "Unknow";
            if (smd != null && smd.getIdentifier() != null) {
                id = smd.getIdentifier().getValue();
            }
            if (perfLog.isLogEnabled()) {
                perfLog.log("IdexTaskGenerator.processSystemMetaDataAdd add a adding task for id " + id, System.currentTimeMillis() - start);
            }
            return task;
        }
        return null;
    }

    public IndexTask processSystemMetaDataUpdate(SystemMetadata smd, String objectPath) {
        if (IgnoringIndexIdPool.isNotIgnorePid((SystemMetadata)smd) && !filter.filter(smd)) {
            long start = System.currentTimeMillis();
            this.removeDuplicateNewTasks(smd);
            IndexTask task = new IndexTask(smd, objectPath);
            task.setUpdatePriority();
            task = (IndexTask)this.repo.save((Object)task);
            String id = "Unknow";
            if (smd != null && smd.getIdentifier() != null) {
                id = smd.getIdentifier().getValue();
            }
            if (perfLog.isLogEnabled()) {
                perfLog.log("IdexTaskGenerator.processSystemMetaDataUpdate add a updating task for id " + id, System.currentTimeMillis() - start);
            }
            return task;
        }
        return null;
    }

    public IndexTask processSystemMetaDataDelete(SystemMetadata smd) {
        if (IgnoringIndexIdPool.isNotIgnorePid((SystemMetadata)smd)) {
            long start = System.currentTimeMillis();
            this.removeDuplicateNewTasks(smd);
            IndexTask task = new IndexTask(smd, null);
            task.setDeleted(true);
            task = (IndexTask)this.repo.save((Object)task);
            String id = "Unknow";
            if (smd != null && smd.getIdentifier() != null) {
                id = smd.getIdentifier().getValue();
            }
            if (perfLog.isLogEnabled()) {
                perfLog.log("IdexTaskGenerator.processSystemMetaDataUpdate add a deleting task for id " + id, System.currentTimeMillis() - start);
            }
            return task;
        }
        return null;
    }

    private void removeDuplicateNewTasks(SystemMetadata smd) {
        this.removeDuplicateTasksByStatus(smd, "NEW");
        this.removeDuplicateTasksByStatus(smd, "FAILED");
    }

    private void removeDuplicateTasksByStatus(SystemMetadata smd, String status) {
        List itList = this.repo.findByPidAndStatus(smd.getIdentifier().getValue(), status);
        for (IndexTask indexTask : itList) {
            try {
                this.repo.delete((Object)indexTask);
            }
            catch (HibernateOptimisticLockingFailureException e) {
                logger.debug((Object)("Unable to delete existing index task for pid: " + indexTask.getPid() + " prior to generating new index task."));
            }
        }
    }

    public void close() throws IOException {
        if (filter != null) {
            filter.closeSolrClient();
        }
    }
}

