/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PreCollectionUpdateEvent;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public final class CollectionUpdateAction
extends CollectionAction {
    private final boolean emptySnapshot;

    public CollectionUpdateAction(PersistentCollection collection, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) throws CacheException {
        super(persister, collection, id, session);
        this.emptySnapshot = emptySnapshot;
    }

    public void execute() throws HibernateException {
        Serializable id = this.getKey();
        SessionImplementor session = this.getSession();
        CollectionPersister persister = this.getPersister();
        PersistentCollection collection = this.getCollection();
        boolean affectedByFilters = persister.isAffectedByEnabledFilters(session);
        this.preUpdate();
        if (!collection.wasInitialized()) {
            if (!collection.hasQueuedOperations()) {
                throw new AssertionFailure("no queued adds");
            }
        } else if (!affectedByFilters && collection.empty()) {
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
        } else if (collection.needsRecreate(persister)) {
            if (affectedByFilters) {
                throw new HibernateException("cannot recreate collection while filter is enabled: " + MessageHelper.collectionInfoString(persister, id, persister.getFactory()));
            }
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
            persister.recreate(collection, id, session);
        } else {
            persister.deleteRows(collection, id, session);
            persister.updateRows(collection, id, session);
            persister.insertRows(collection, id, session);
        }
        this.getSession().getPersistenceContext().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postUpdate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().updateCollection(this.getPersister().getRole());
        }
    }

    private void preUpdate() {
        PreCollectionUpdateEventListener[] preListeners = this.getSession().getListeners().getPreCollectionUpdateEventListeners();
        if (preListeners.length > 0) {
            PreCollectionUpdateEvent preEvent = new PreCollectionUpdateEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession());
            for (int i = 0; i < preListeners.length; ++i) {
                preListeners[i].onPreUpdateCollection(preEvent);
            }
        }
    }

    private void postUpdate() {
        PostCollectionUpdateEventListener[] postListeners = this.getSession().getListeners().getPostCollectionUpdateEventListeners();
        if (postListeners.length > 0) {
            PostCollectionUpdateEvent postEvent = new PostCollectionUpdateEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostUpdateCollection(postEvent);
            }
        }
    }
}

