/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.resourcemap;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.processor.IndexVisibilityDelegateHazelcastImpl;
import org.dataone.cn.indexer.parser.utility.SeriesIdResolver;
import org.dataone.cn.indexer.resourcemap.ForesiteResourceEntry;
import org.dataone.cn.indexer.resourcemap.IndexVisibilityDelegate;
import org.dataone.cn.indexer.resourcemap.ResourceEntry;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREParserException;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class ForesiteResourceMap
implements ResourceMap {
    private static final String RESOURCE_MAP_FORMAT = "http://www.openarchives.org/ore/terms";
    private static Logger logger = Logger.getLogger((String)ForesiteResourceMap.class.getName());
    private String identifier = null;
    private HashMap<String, ForesiteResourceEntry> resourceMap = null;
    private IndexVisibilityDelegate indexVisibilityDelegate = new IndexVisibilityDelegateHazelcastImpl();

    public ForesiteResourceMap(String fileObjectPath) throws OREParserException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileObjectPath);
            this._init(fileInputStream);
        }
        catch (Exception e) {
            throw new OREParserException((Throwable)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"error closing file input stream", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForesiteResourceMap(Document doc) throws OREParserException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            DOMImplementationLS domImpl = null;
            try {
                domImpl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
                LSOutput lsOutput = domImpl.createLSOutput();
                lsOutput.setEncoding("UTF-8");
                lsOutput.setByteStream(bos);
                LSSerializer lsSerializer = domImpl.createLSSerializer();
                lsSerializer.write(doc, lsOutput);
                is = new ReaderInputStream((Reader)new StringReader(bos.toString()));
                this._init(is);
            }
            catch (Exception e) {
                throw new OREParserException((Throwable)e);
            }
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                throw new OREParserException((Throwable)e);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new OREParserException((Throwable)e);
                }
            }
        }
    }

    public ForesiteResourceMap(String fileObjectPath, IndexVisibilityDelegate ivd) throws OREParserException {
        if (ivd != null) {
            this.indexVisibilityDelegate = ivd;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileObjectPath);
            this._init(fileInputStream);
        }
        catch (Exception e) {
            throw new OREParserException((Throwable)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"error closing file input stream", (Throwable)e);
            }
        }
    }

    private void _init(InputStream is) throws OREException, URISyntaxException, UnsupportedEncodingException, OREParserException {
        Map tmpResourceMap = null;
        try {
            tmpResourceMap = ResourceMapFactory.getInstance().parseResourceMap(is);
        }
        catch (Throwable e) {
            logger.error((Object)"Unable to parse ORE document:", e);
            throw new OREParserException(e);
        }
        Identifier identifier = (Identifier)tmpResourceMap.keySet().iterator().next();
        this.setIdentifier(identifier.getValue());
        Map identiferMap = (Map)tmpResourceMap.get(identifier);
        this.resourceMap = new HashMap();
        for (Map.Entry entry : identiferMap.entrySet()) {
            ForesiteResourceEntry documentsResourceEntry = this.resourceMap.get(((Identifier)entry.getKey()).getValue());
            if (documentsResourceEntry == null) {
                documentsResourceEntry = new ForesiteResourceEntry(((Identifier)entry.getKey()).getValue(), this);
                this.resourceMap.put(((Identifier)entry.getKey()).getValue(), documentsResourceEntry);
            }
            for (Identifier documentedByIdentifier : (List)entry.getValue()) {
                ForesiteResourceEntry documentedByResourceEntry;
                Identifier pid = new Identifier();
                pid.setValue(documentedByIdentifier.getValue());
                if (this.indexVisibilityDelegate.isDocumentVisible(pid)) {
                    documentsResourceEntry.addDocuments(documentedByIdentifier.getValue());
                }
                if ((documentedByResourceEntry = this.resourceMap.get(documentedByIdentifier.getValue())) == null) {
                    documentedByResourceEntry = new ForesiteResourceEntry(documentedByIdentifier.getValue(), this);
                    this.resourceMap.put(documentedByIdentifier.getValue(), documentedByResourceEntry);
                }
                pid = new Identifier();
                pid.setValue(((Identifier)entry.getKey()).getValue());
                if (!this.indexVisibilityDelegate.isDocumentVisible(pid)) continue;
                documentedByResourceEntry.addDocumentedBy(((Identifier)entry.getKey()).getValue());
            }
        }
    }

    public static boolean representsResourceMap(String formatId) {
        return RESOURCE_MAP_FORMAT.equals(formatId);
    }

    private boolean isHeadVersion(Identifier pid, Identifier sid) {
        boolean isHead = true;
        if (pid != null && sid != null) {
            Identifier head = null;
            try {
                head = SeriesIdResolver.getPid(sid);
            }
            catch (Exception e) {
                System.out.println("" + e.getStackTrace());
                isHead = true;
            }
            if (head != null) {
                logger.info((Object)("||||||||||||||||||| the head version is " + head.getValue() + " for sid " + sid.getValue()));
                if (head.equals((Object)pid)) {
                    logger.info((Object)("||||||||||||||||||| the pid " + pid.getValue() + " is the head version for sid " + sid.getValue()));
                    isHead = true;
                } else {
                    logger.info((Object)("||||||||||||||||||| the pid " + pid.getValue() + " is NOT the head version for sid " + sid.getValue()));
                    isHead = false;
                }
            } else {
                logger.info((Object)("||||||||||||||||||| can't find the head version for sid " + sid.getValue() + " and we think the given pid " + pid.getValue() + " is the head version."));
            }
        }
        return isHead;
    }

    private SolrDoc _mergeMappedReference(ResourceEntry resourceEntry, SolrDoc mergeDocument) {
        Identifier identifier = new Identifier();
        identifier.setValue(mergeDocument.getIdentifier());
        SystemMetadata sysMeta = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)identifier);
        if (sysMeta.getSeriesId() != null && sysMeta.getSeriesId().getValue() != null && !sysMeta.getSeriesId().getValue().trim().equals("") && !this.isHeadVersion(identifier, sysMeta.getSeriesId())) {
            logger.info((Object)("The id " + identifier + " is not the head of the serial id " + sysMeta.getSeriesId().getValue() + " So, skip merge this one!!!!!!!!!!!!!!!!!!!!!!" + mergeDocument.getIdentifier()));
            return mergeDocument;
        }
        if (!mergeDocument.hasField("id")) {
            mergeDocument.addField(new SolrElementField("id", resourceEntry.getIdentifier()));
        }
        for (String documentedBy : resourceEntry.getDocumentedBy()) {
            if (mergeDocument.hasFieldWithValue("isDocumentedBy", documentedBy)) continue;
            mergeDocument.addField(new SolrElementField("isDocumentedBy", documentedBy));
        }
        for (String documents : resourceEntry.getDocuments()) {
            if (mergeDocument.hasFieldWithValue("documents", documents)) continue;
            mergeDocument.addField(new SolrElementField("documents", documents));
        }
        for (String resourceMap : resourceEntry.getResourceMaps()) {
            if (mergeDocument.hasFieldWithValue("resourceMap", resourceMap)) continue;
            mergeDocument.addField(new SolrElementField("resourceMap", resourceMap));
        }
        mergeDocument.setMerged(true);
        return mergeDocument;
    }

    @Override
    public Set<ResourceEntry> getMappedReferences() {
        HashSet<ResourceEntry> resourceEntries = new HashSet<ResourceEntry>();
        for (ResourceEntry resourceEntry : this.resourceMap.values()) {
            Identifier pid = new Identifier();
            pid.setValue(resourceEntry.getIdentifier());
            if (this.indexVisibilityDelegate.documentExists(pid) && !this.indexVisibilityDelegate.isDocumentVisible(pid) || resourceEntry.getIdentifier().equals(this.getIdentifier())) continue;
            resourceEntries.add(resourceEntry);
        }
        return resourceEntries;
    }

    @Override
    public Set<String> getContains() {
        HashSet<String> contains = new HashSet<String>();
        for (String string : this.resourceMap.keySet()) {
            contains.add(string);
        }
        for (ResourceEntry resourceEntry : this.resourceMap.values()) {
            contains.add(resourceEntry.getIdentifier());
        }
        return contains;
    }

    @Override
    public List<String> getAllDocumentIDs() {
        LinkedList<String> docIds = new LinkedList<String>();
        docIds.add(this.getIdentifier());
        for (ResourceEntry resourceEntry : this.getMappedReferences()) {
            docIds.add(resourceEntry.getIdentifier());
        }
        return docIds;
    }

    @Override
    public List<SolrDoc> mergeIndexedDocuments(List<SolrDoc> docs) {
        ArrayList<SolrDoc> mergedDocuments = new ArrayList<SolrDoc>();
        for (ResourceEntry resourceEntry : this.resourceMap.values()) {
            for (SolrDoc doc : docs) {
                logger.debug((Object)(">>>>>>>>in mergeIndexedDocuments of ForesiteResourceMap, the doc id is  " + doc.getIdentifier() + " in the thread " + Thread.currentThread().getId()));
                logger.debug((Object)(">>>>>>>>in mergeIndexedDocuments of ForesiteResourceMap, the doc series id is  " + doc.getSeriesId() + " in the thread " + Thread.currentThread().getId()));
                logger.debug((Object)(">>>>>>>>in mergeIndexedDocuments of ForesiteResourceMap, the resource entry id is  " + resourceEntry.getIdentifier() + " in the thread " + Thread.currentThread().getId()));
                if (!doc.getIdentifier().equals(resourceEntry.getIdentifier()) && !resourceEntry.getIdentifier().equals(doc.getSeriesId())) continue;
                mergedDocuments.add(this._mergeMappedReference(resourceEntry, doc));
            }
        }
        return mergedDocuments;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

