/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.hazelcast;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.hazelcast.ClientConfiguration;
import org.dataone.configuration.Settings;

public class HazelcastClientInstance {
    public static final Log logger = LogFactory.getLog(HazelcastClientInstance.class);
    private static HazelcastClient hzclient = null;
    private static final String hzConfigLocation = Settings.getConfiguration().getString("dataone.hazelcast.location.clientconfig");

    public static HazelcastClient getHazelcastClient() {
        if (hzclient == null) {
            ClientConfiguration clientConfiguration = null;
            try {
                if (hzConfigLocation != null) {
                    if (hzConfigLocation.startsWith("classpath:")) {
                        String hzConfigLocationConfig = hzConfigLocation.replace("classpath:", "");
                        ClasspathXmlConfig config = new ClasspathXmlConfig(hzConfigLocationConfig);
                        clientConfiguration = new ClientConfiguration((Config)config);
                    } else {
                        clientConfiguration = new ClientConfiguration(hzConfigLocation);
                    }
                } else {
                    clientConfiguration = new ClientConfiguration();
                }
            }
            catch (FileNotFoundException ex) {
                throw new NullPointerException("FileNotFound so clientConfiguration is Null: " + ex.getMessage());
            }
            logger.info((Object)("group " + clientConfiguration.getGroup() + " pwd " + clientConfiguration.getPassword() + " addresses " + clientConfiguration.getLocalhost()));
            ClientConfig cc = new ClientConfig();
            cc.getGroupConfig().setName(clientConfiguration.getGroup());
            cc.getGroupConfig().setPassword(clientConfiguration.getPassword());
            cc.addAddress(new String[]{clientConfiguration.getLocalhost()});
            hzclient = HazelcastClient.newHazelcastClient((ClientConfig)cc);
        }
        return hzclient;
    }
}

