/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v1.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dataone.client.auth.ClientIdentityManager;
import org.dataone.client.v1.CNode;
import org.dataone.client.v1.MNode;
import org.dataone.client.v1.itk.D1Client;
import org.dataone.client.v1.types.D1TypeBuilder;
import org.dataone.exceptions.MarshallingException;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.ObjectLocation;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class ExampleDataPackageUpload {
    private static final String TARGET_MN_BASE_URL = "https://mn-sandbox-ucsb-1.test.dataone.org:443/knb/d1/mn";
    private static final String SOURCE_CN_BASE_URL = "https://cn-ucsb-1.dataone.org:443/cn";
    private static final String PACKAGE_DIR = "/tmp/";
    private static final String SYSMETA_SUFFIX = ".SYSMETA";

    public static void main(String[] args) throws ServiceFailure {
        MNode targetMN = D1Client.getMN(TARGET_MN_BASE_URL);
        CNode sourceCN = D1Client.getCN(SOURCE_CN_BASE_URL);
        ExampleDataPackageUpload edpu = new ExampleDataPackageUpload();
        String query = ExampleDataPackageUpload.buildQueryString();
        List<Identifier> oreIdentifiers = edpu.getDataPackagesToCopy(sourceCN, query);
        edpu.copyDataPackages(sourceCN, targetMN, oreIdentifiers);
    }

    private static String buildQueryString() {
        String baseResourceMapQuery = "?q=formatType:RESOURCE";
        String daacFilter = "datasource:urn%5C:node%5C:ORNLDAAC";
        String countToCopy = "rows=2";
        String copyOffset = "start=10";
        String query = baseResourceMapQuery + "%20" + daacFilter + "&" + copyOffset + "&" + countToCopy;
        return query;
    }

    public void copyDataPackages(CNode sourceCN, MNode targetMN, List<Identifier> oreIdentifiers) {
        try {
            int packageCount = 0;
            for (Identifier orePid : oreIdentifiers) {
                File tmpDir = this.createTempPackageDir(packageCount);
                int docCount = 0;
                boolean downloadedAllDocs = true;
                Set<String> uniquePids = this.getUniqueIdsFromOre(orePid, sourceCN);
                for (String pidString : uniquePids) {
                    System.out.println("Id: " + pidString);
                    Identifier docPid = D1TypeBuilder.buildIdentifier((String)pidString);
                    InputStream is = this.getDocumentFromCnResolve(sourceCN, docPid);
                    if (is == null) {
                        System.out.println("unable to resolve pid: " + docPid.getValue() + " skipping to next data package.");
                        downloadedAllDocs = false;
                        break;
                    }
                    String docFilePath = tmpDir.getAbsolutePath() + "//doc" + docCount;
                    this.writeDocToDir(tmpDir, is, docFilePath);
                    this.writeSystemMetadataToDir(sourceCN, docPid, docFilePath);
                    ++docCount;
                }
                if (downloadedAllDocs) {
                    boolean success = this.uploadDataPackageWithRetry(targetMN, tmpDir, 5);
                    if (success) {
                        this.deleteTempPackageDir(tmpDir);
                    }
                } else {
                    this.deleteTempPackageDir(tmpDir);
                }
                ++packageCount;
            }
        }
        catch (Exception be) {
            System.out.println(be.getMessage());
        }
    }

    public void uploadDataPackages(MNode targetMN, File rootDir) {
        File[] listOfFiles = rootDir.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            File file = listOfFiles[i];
            if (!file.isDirectory()) continue;
            this.uploadDataPackageWithRetry(targetMN, file, 10);
        }
    }

    public boolean uploadDataPackageWithRetry(MNode targetMN, File tmpDir, int uploadRetries) {
        boolean success = false;
        int trycount = 0;
        do {
            success = this.uploadDataPackageFromDir(targetMN, tmpDir);
            if (trycount > uploadRetries) {
                System.out.println("Unable to upload data package - finished retries - not deleting.");
                break;
            }
            ++trycount;
        } while (!success);
        return success;
    }

    private List<Identifier> getDataPackagesToCopy(CNode cn, String queryString) {
        ArrayList<Identifier> idList = new ArrayList<Identifier>();
        ObjectList objects = new ObjectList();
        try {
            objects = cn.search("solr", queryString);
        }
        catch (BaseException be) {
            System.out.println(be.getMessage());
        }
        for (ObjectInfo objectInfo : objects.getObjectInfoList()) {
            idList.add(objectInfo.getIdentifier());
        }
        return idList;
    }

    private boolean uploadDataPackageFromDir(MNode mn, File packageDir) {
        File[] listOfFiles = packageDir.listFiles();
        boolean success = true;
        for (int i = 0; i < listOfFiles.length; ++i) {
            File file = listOfFiles[i];
            String smdFileName = file.getName();
            String smdFilePath = file.getAbsolutePath();
            if (!StringUtils.endsWith((String)smdFileName, (String)SYSMETA_SUFFIX)) continue;
            System.out.println("found sysmeta: " + smdFilePath);
            SystemMetadata smd = this.unMarshalSystemMetadata(file.getAbsolutePath());
            if (smd == null) continue;
            String documentFilePath = StringUtils.removeEnd((String)smdFilePath, (String)SYSMETA_SUFFIX);
            File documentFile = new File(documentFilePath);
            if (!documentFile.exists() || !documentFile.isFile()) {
                System.err.println("file: " + documentFilePath + " not found.");
                continue;
            }
            smd = this.updateSystemMetadata(smd);
            try {
                Identifier id = mn.create(null, smd.getIdentifier(), new FileInputStream(documentFilePath), smd);
                System.out.println("Identifier: " + id.getValue() + " created on target MN.");
            }
            catch (IdentifierNotUnique inu) {
                System.out.println(inu.getMessage());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                success = false;
            }
            System.out.println("");
        }
        return success;
    }

    private SystemMetadata updateSystemMetadata(SystemMetadata smd) {
        Subject clientSubject = ClientIdentityManager.getCurrentIdentity();
        smd.setSubmitter(clientSubject);
        AccessRule ar = D1TypeBuilder.buildAccessRule((String)"public", (Permission)Permission.READ);
        smd.getAccessPolicy().addAllow(ar);
        smd.clearReplicaList();
        smd.setObsoletedBy(null);
        smd.setObsoletes(null);
        smd.setArchived(Boolean.valueOf(false));
        return smd;
    }

    private void writeSystemMetadataToDir(CNode cn, Identifier pid, String docFilePath) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, MarshallingException, FileNotFoundException, IOException {
        SystemMetadata smd = cn.getSystemMetadata(pid);
        TypeMarshaller.marshalTypeToFile((Object)smd, (String)(docFilePath + SYSMETA_SUFFIX));
    }

    private void writeDocToDir(File tmpDir, InputStream is, String targetFilePath) throws FileNotFoundException, IOException {
        FileOutputStream os = new FileOutputStream(targetFilePath);
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    private InputStream getDocumentFromCnResolve(CNode cn, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        InputStream is = null;
        ObjectLocationList oll = cn.resolve(pid);
        for (ObjectLocation location : oll.getObjectLocationList()) {
            try {
                URL url = new URL(location.getUrl());
                is = url.openConnection().getInputStream();
                break;
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
        return is;
    }

    private void deleteTempPackageDir(File tmpDir) {
        File[] listOfFiles;
        for (File tmpFile : listOfFiles = tmpDir.listFiles()) {
            tmpFile.delete();
        }
        tmpDir.delete();
    }

    private File createTempPackageDir(int packageCount) {
        File tmpDir = new File("/tmp///package" + packageCount);
        tmpDir.mkdir();
        return tmpDir;
    }

    private SystemMetadata unMarshalSystemMetadata(String filePath) {
        SystemMetadata smd = null;
        try {
            FileInputStream is = new FileInputStream(filePath);
            smd = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)is);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return smd;
    }

    private Set<String> getUniqueIdsFromOre(Identifier orePid, CNode cn) {
        HashSet<String> uniquePids = new HashSet<String>();
        try {
            InputStream oreDoc = cn.get(orePid);
            Map<Identifier, Map<Identifier, List<Identifier>>> map = ResourceMapFactory.getInstance().parseResourceMap(oreDoc);
            for (Identifier id : map.keySet()) {
                uniquePids.add(id.getValue());
                Map<Identifier, List<Identifier>> documentsMap = map.get(id);
                for (Identifier documentsId : documentsMap.keySet()) {
                    uniquePids.add(documentsId.getValue());
                    List<Identifier> documentedList = documentsMap.get(documentsId);
                    for (Identifier documentedByPid : documentedList) {
                        uniquePids.add(documentedByPid.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return uniquePids;
    }
}

