/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.EntryListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.DataAwareEntryEvent;
import com.hazelcast.impl.Keys;
import com.hazelcast.nio.Data;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryListenerManager {
    private final Object NULL_KEY = new Object();
    private final ConcurrentMap<String, ConcurrentHashMap<Object, List<EntryListenerHolder>>> entryListeners = new ConcurrentHashMap<String, ConcurrentHashMap<Object, List<EntryListenerHolder>>>();

    public synchronized void registerListener(String name, Object key, boolean includeValue, EntryListener<?, ?> entryListener) {
        ConcurrentHashMap map2;
        ConcurrentHashMap map = (ConcurrentHashMap)this.entryListeners.get(name);
        key = this.toKey(key);
        if (map == null && (map2 = this.entryListeners.putIfAbsent(name, map = new ConcurrentHashMap())) != null) {
            map = map2;
        }
        if (!map.contains(key)) {
            map.putIfAbsent(key, new CopyOnWriteArrayList());
        }
        ((List)map.get(key)).add(new EntryListenerHolder(entryListener, includeValue));
    }

    private Object toKey(Object key) {
        return key != null ? key : this.NULL_KEY;
    }

    private Object fromKey(Object key) {
        return key != this.NULL_KEY ? key : null;
    }

    public synchronized void removeListener(String name, Object key, EntryListener<?, ?> entryListener) {
        Map m = (Map)this.entryListeners.get(name);
        if (m != null) {
            List list = (List)m.get(key = this.toKey(key));
            if (list != null) {
                for (EntryListenerHolder entryListenerHolder : list) {
                    if (!entryListenerHolder.listener.equals(entryListener)) continue;
                    list.remove(entryListenerHolder);
                }
                if (((List)m.get(key)).isEmpty()) {
                    m.remove(key);
                }
            }
            if (m.isEmpty()) {
                this.entryListeners.remove(name);
            }
        }
    }

    public synchronized Boolean noListenerRegistered(Object key, String name, boolean includeValue) {
        Map map = (Map)this.entryListeners.get(name);
        key = this.toKey(key);
        if (map == null || map.get(key) == null) {
            return Boolean.TRUE;
        }
        for (EntryListenerHolder holder : (List)map.get(key)) {
            if (holder.includeValue == includeValue) {
                return Boolean.FALSE;
            }
            if (!includeValue) continue;
            return null;
        }
        return Boolean.TRUE;
    }

    public void notifyListeners(Packet packet) {
        Object keyObj = IOUtil.toObject(packet.getKey());
        Object value = IOUtil.toObject(packet.getValue());
        Data newValue = null;
        Data oldValue = null;
        if (value instanceof Keys) {
            Keys values = (Keys)value;
            Iterator<Data> it = values.getKeys().iterator();
            newValue = it.hasNext() ? new Data(it.next().buffer) : null;
            oldValue = it.hasNext() ? new Data(it.next().buffer) : null;
        } else {
            newValue = new Data(packet.getValue());
        }
        DataAwareEntryEvent event = new DataAwareEntryEvent(null, (int)packet.getLongValue(), packet.getName(), new Data(packet.getKey()), newValue, oldValue, false);
        String name = packet.getName();
        Object key = this.toKey(keyObj);
        if (this.entryListeners.get(name) != null) {
            this.notifyListeners(event, (Collection)((ConcurrentHashMap)this.entryListeners.get(name)).get(this.NULL_KEY));
            if (key != this.NULL_KEY) {
                this.notifyListeners(event, (Collection)((ConcurrentHashMap)this.entryListeners.get(name)).get(key));
            }
        }
    }

    private void notifyListeners(DataAwareEntryEvent event, Collection<EntryListenerHolder> collection) {
        if (collection == null) {
            return;
        }
        DataAwareEntryEvent eventNoValue = event.getValue() != null ? new DataAwareEntryEvent(event.getMember(), event.getEventType().getType(), event.getName(), event.getKeyData(), null, null, false) : event;
        switch (event.getEventType()) {
            case ADDED: {
                for (EntryListenerHolder holder : collection) {
                    holder.listener.entryAdded(holder.includeValue ? event : eventNoValue);
                }
                break;
            }
            case UPDATED: {
                for (EntryListenerHolder holder : collection) {
                    holder.listener.entryUpdated(holder.includeValue ? event : eventNoValue);
                }
                break;
            }
            case REMOVED: {
                for (EntryListenerHolder holder : collection) {
                    holder.listener.entryRemoved(holder.includeValue ? event : eventNoValue);
                }
                break;
            }
            case EVICTED: {
                for (EntryListenerHolder holder : collection) {
                    holder.listener.entryEvicted(holder.includeValue ? event : eventNoValue);
                }
                break;
            }
        }
    }

    public Call createNewAddListenerCall(ProxyHelper proxyHelper, Object key, boolean includeValue) {
        Packet request = proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, IOUtil.toByte(key), null);
        request.setLongValue(includeValue ? 1L : 0L);
        return proxyHelper.createCall(request);
    }

    public Collection<Call> calls(HazelcastClient client) {
        ArrayList<Call> calls = new ArrayList<Call>();
        for (Map.Entry entry : this.entryListeners.entrySet()) {
            String name = (String)entry.getKey();
            ConcurrentHashMap value = (ConcurrentHashMap)entry.getValue();
            for (Map.Entry anotherEntry : value.entrySet()) {
                EntryListenerHolder entryListenerHolder;
                boolean includeValue = false;
                Object key = this.fromKey(anotherEntry.getKey());
                Iterator i$ = ((List)anotherEntry.getValue()).iterator();
                while (i$.hasNext() && !(includeValue |= (entryListenerHolder = (EntryListenerHolder)i$.next()).includeValue)) {
                }
                ProxyHelper proxyHelper = new ProxyHelper(name, client);
                calls.add(this.createNewAddListenerCall(proxyHelper, key, includeValue));
            }
        }
        return calls;
    }

    private static class EntryListenerHolder {
        private final EntryListener listener;
        private boolean includeValue;

        public EntryListenerHolder(EntryListener listener, boolean includeValue) {
            this.listener = listener;
            this.includeValue = includeValue;
        }
    }
}

