/*
 * Decompiled with CFR 0.152.
 */
package example;

import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

class EmailTableModel
extends AbstractTableModel {
    PSTFolder theFolder = null;
    PSTFile theFile = null;
    HashMap cache = new HashMap();
    String[] columnNames = new String[]{"Descriptor ID", "Subject", "From", "To", "Date", "Has Attachments"};
    String[][] rowData = new String[][]{{"", "", "", "", ""}};
    int rowCount = 0;

    public EmailTableModel(PSTFolder theFolder, PSTFile theFile) {
        this.theFolder = theFolder;
        this.theFile = theFile;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        try {
            return this.theFolder.getContentCount();
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(0);
            return 0;
        }
    }

    public PSTMessage getMessageAtRow(int row) {
        PSTMessage next = null;
        try {
            if (this.cache.containsKey(row)) {
                next = (PSTMessage)this.cache.get(row);
            } else {
                this.theFolder.moveChildCursorTo(row);
                next = (PSTMessage)this.theFolder.getNextChild();
                this.cache.put(row, next);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return next;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            PSTMessage next = this.getMessageAtRow(row);
            if (next == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return next.getDescriptorNode().descriptorIdentifier + "";
                }
                case 1: {
                    return next.getSubject();
                }
                case 2: {
                    return next.getSentRepresentingName() + " <" + next.getSentRepresentingEmailAddress() + ">";
                }
                case 3: {
                    return next.getReceivedByName() + " <" + next.getReceivedByAddress() + ">" + next.getDisplayTo();
                }
                case 4: {
                    return next.getClientSubmitTime();
                }
                case 5: {
                    return next.hasAttachments() ? "Yes" : "No";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setFolder(PSTFolder theFolder) throws PSTException, IOException {
        theFolder.moveChildCursorTo(0);
        this.theFolder = theFolder;
        this.cache = new HashMap();
        this.fireTableDataChanged();
    }
}

