/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.CardinalityQRestriction;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.QualifiedRestrictionImpl;

public class CardinalityQRestrictionImpl
extends QualifiedRestrictionImpl
implements CardinalityQRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new CardinalityQRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to CardinalityQRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return CardinalityQRestrictionImpl.isCardinalityQRestriction(node, eg);
        }
    };

    public static boolean isCardinalityQRestriction(Node node, EnhGraph eg) {
        Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
        return profile != null && profile.isSupported(node, eg, CardinalityQRestriction.class);
    }

    @Override
    public boolean isValid() {
        return CardinalityQRestrictionImpl.isCardinalityQRestriction(this.asNode(), this.getGraph());
    }

    public CardinalityQRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setCardinalityQ(int cardinality) {
        this.setPropertyValue(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getCardinalityQ() {
        return this.objectAsInt(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q");
    }

    @Override
    public boolean hasCardinalityQ(int cardinality) {
        return this.hasPropertyValue(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeCardinalityQ(int cardinality) {
        this.removePropertyValue(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }
}

