/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommandProcessor;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.memcache.GetCommand;
import com.hazelcast.impl.ascii.memcache.MemcacheEntry;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCommandProcessor
extends AbstractTextCommandProcessor<GetCommand> {
    final boolean single;
    private final ILogger logger;

    public GetCommandProcessor(TextCommandService textCommandService, boolean single) {
        super(textCommandService);
        this.single = single;
        this.logger = textCommandService.getNode().getLogger(this.getClass().getName());
    }

    @Override
    public void handle(GetCommand getCommand) {
        String key = null;
        try {
            key = URLDecoder.decode(getCommand.getKey(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        String mapName = "default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = key.substring(0, index);
            key = key.substring(index + 1);
        }
        Object value = this.textCommandService.get(mapName, key);
        MemcacheEntry entry = null;
        if (value != null) {
            if (value instanceof MemcacheEntry) {
                entry = (MemcacheEntry)value;
            } else if (value instanceof byte[]) {
                entry = new MemcacheEntry(getCommand.getKey(), (byte[])value, 0);
            } else if (value instanceof String) {
                entry = new MemcacheEntry(getCommand.getKey(), ((String)value).getBytes(), 0);
            } else {
                try {
                    entry = new MemcacheEntry(getCommand.getKey(), IOUtil.serializeToBytes(value), 0);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        this.textCommandService.incrementGetCount();
        if (entry != null) {
            this.textCommandService.incrementHitCount();
        }
        getCommand.setValue(entry, this.single);
        this.textCommandService.sendResponse(getCommand);
    }

    @Override
    public void handleRejection(GetCommand getCommand) {
        getCommand.setValue(null, this.single);
        this.textCommandService.sendResponse(getCommand);
    }
}

