/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.FTPClient;
import org.globus.ftp.FeatureList;
import org.globus.ftp.FileRandomIO;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.HostPort;
import org.globus.ftp.HostPortList;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.extended.GridFTPControlChannel;
import org.globus.ftp.extended.GridFTPServerFacade;
import org.globus.ftp.vanilla.Command;
import org.globus.ftp.vanilla.Reply;
import org.globus.gsi.gssapi.auth.Authorization;
import org.ietf.jgss.GSSCredential;

public class GridFTPClient
extends FTPClient {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$GridFTPClient == null ? (class$org$globus$ftp$GridFTPClient = GridFTPClient.class$("org.globus.ftp.GridFTPClient")) : class$org$globus$ftp$GridFTPClient).getName());
    protected GridFTPSession gSession;
    protected GridFTPServerFacade gLocalServer = new GridFTPServerFacade();
    static /* synthetic */ Class class$org$globus$ftp$GridFTPClient;

    public GridFTPClient(String host, int port) throws IOException, ServerException {
        this.localServer = this.gLocalServer;
        this.gLocalServer.authorize();
        this.gSession = new GridFTPSession();
        this.session = this.gSession;
        this.controlChannel = new GridFTPControlChannel(host, port);
        this.controlChannel.open();
    }

    public void authenticate(GSSCredential credential) throws IOException, ServerException {
        ((GridFTPControlChannel)this.controlChannel).authenticate(credential);
        this.gLocalServer.setCredential(credential);
        this.gSession.authorized = true;
    }

    public Vector list() throws ServerException, ClientException, IOException {
        if (this.gSession.parallel > 1) {
            throw new ClientException(8, "list() cannot be called with parallelism");
        }
        return super.list();
    }

    public void list(String filter, String modifier, DataSink sink) throws ServerException, ClientException, IOException {
        if (!this.gSession.needsGridFTP()) {
            super.list(filter, modifier, sink);
            return;
        }
        this.gSession.matches(this.localServer.getSession());
        if (this.gSession.serverMode == -1) {
            HostPort hp = this.setLocalPassive();
            this.setActive(hp);
        }
        super.actualList(filter, modifier, sink);
    }

    protected void listCheck() throws ClientException {
    }

    public void setMode(int mode) throws IOException, ServerException {
        String modeStr = null;
        switch (mode) {
            case 1: {
                modeStr = "S";
                break;
            }
            case 2: {
                modeStr = "B";
                break;
            }
            case 3: {
                modeStr = "E";
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad mode");
            }
        }
        this.actualSetMode(mode, modeStr);
    }

    public void setTCPBufferSize(int size) throws IOException, ServerException {
        try {
            if (size <= 0) {
                throw new IllegalArgumentException("size <= 0");
            }
            boolean succeeded = false;
            String sizeString = Integer.toString(size);
            FeatureList feat = this.getFeatureList();
            if (feat.contains("SBUF")) {
                succeeded = this.tryExecutingCommand(new Command("SBUF", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingCommand(new Command("SITE BUFSIZE", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingTwoCommands(new Command("SITE RETRBUFSIZE", sizeString), new Command("SITE STORBUFIZE", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingTwoCommands(new Command("SITE RBUFSZ", sizeString), new Command("SITE SBUFSZ", sizeString));
            }
            if (!succeeded) {
                succeeded = this.tryExecutingTwoCommands(new Command("SITE RBUFSIZ", sizeString), new Command("SITE SBUFSIZ", sizeString));
            }
            if (!succeeded) {
                throw new ServerException(1, "Server refused setting TCP buffer size with any of the known commands.");
            }
            this.gSession.TCPBufferSize = size;
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
    }

    private boolean tryExecutingTwoCommands(Command cmd1, Command cmd2) throws IOException, FTPReplyParseException {
        boolean result = this.tryExecutingCommand(cmd1);
        if (result) {
            result = this.tryExecutingCommand(cmd2);
        }
        return result;
    }

    private boolean tryExecutingCommand(Command cmd) throws IOException, FTPReplyParseException {
        Reply reply = this.controlChannel.exchange(cmd);
        return Reply.isPositiveCompletion(reply);
    }

    public void setLocalTCPBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.gLocalServer.setTCPBufferSize(size);
    }

    public HostPortList setStripedPassive() throws IOException, ServerException {
        Reply reply = null;
        try {
            reply = this.controlChannel.execute(Command.SPAS);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.serverMode = 3;
        this.gSession.serverAddressList = new HostPortList(reply.getMessage());
        return this.gSession.serverAddressList;
    }

    public void setStripedActive(HostPortList hpl) throws IOException, ServerException {
        Command cmd = new Command("SPOR", hpl.toFtpCmdArgument());
        try {
            this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.serverMode = 4;
    }

    public HostPortList setLocalStripedPassive(int port, int queue) throws IOException {
        return this.gLocalServer.setStripedPassive(port, queue);
    }

    public HostPortList setLocalStripedPassive() throws IOException {
        return this.gLocalServer.setStripedPassive();
    }

    public void setLocalStripedActive() throws ClientException, IOException {
        if (this.gSession.serverAddressList == null) {
            throw new ClientException(10);
        }
        try {
            this.gLocalServer.setStripedActive(this.gSession.serverAddressList);
        }
        catch (UnknownHostException e) {
            throw new ClientException(12);
        }
    }

    public void get(String remoteFileName, DataSink sink, MarkerListener mListener) throws IOException, ClientException, ServerException {
        if (!this.gSession.needsGridFTP()) {
            super.get(remoteFileName, sink, mListener);
            return;
        }
        throw new ClientException(8, "This method does not implement mode E.");
    }

    public void extendedGet(String remoteFileName, long size, DataSink sink, MarkerListener mListener) throws IOException, ClientException, ServerException {
        this.checkGridFTPSupport();
        this.gSession.matches(this.localServer.getSession());
        if (this.gSession.transferMode != 3) {
            throw new ClientException(8, "Extended transfer mode is necessary");
        }
        if (this.gSession.serverMode == -1) {
            HostPort hp = this.setLocalPassive();
            this.setActive(hp);
        }
        logger.debug((Object)"localServer.store()");
        this.gLocalServer.store(sink);
        this.controlChannel.write(new Command("ERET", "P 0 " + size + " " + remoteFileName));
        this.transferRun(this.localServer.getControlChannel(), mListener);
    }

    public void put(String remoteFileName, DataSource source, MarkerListener mListener) throws IOException, ServerException, ClientException {
        if (!this.gSession.needsGridFTP()) {
            super.put(remoteFileName, source, mListener);
            return;
        }
        throw new ClientException(8, "This method does not implement mode E.");
    }

    public void extendedPut(String remoteFileName, DataSource source, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.checkGridFTPSupport();
        this.gSession.matches(this.localServer.getSession());
        if (this.gSession.transferMode != 3) {
            throw new ClientException(8, "Extended transfer mode is necessary");
        }
        if (this.gSession.serverMode == -1) {
            HostPort hp = this.setPassive();
            this.setLocalActive();
        }
        logger.debug((Object)"localServer.retrieve()");
        this.localServer.retrieve(source);
        this.controlChannel.write(new Command("ESTO", "A 0 " + remoteFileName));
        this.transferRun(this.localServer.getControlChannel(), mListener);
    }

    public void extendedTransfer(String remoteSrcFile, GridFTPClient destination, String remoteDstFile, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.checkGridFTPSupport();
        destination.checkGridFTPSupport();
        this.gSession.matches(destination.gSession);
        if (this.gSession.transferMode != 3) {
            throw new ClientException(8, "Extended transfer mode is necessary");
        }
        if (this.gSession.serverMode == -1) {
            HostPort hp = destination.setPassive();
            this.setActive(hp);
        }
        long sourceFileSize = this.getSize(remoteSrcFile);
        destination.controlChannel.write(new Command("ESTO", "A 0 " + remoteDstFile));
        this.controlChannel.write(new Command("ERET", "P 0 " + sourceFileSize + " " + remoteSrcFile));
        this.transferRun(destination.controlChannel, mListener);
    }

    protected void checkGridFTPSupport() throws IOException, ServerException {
        FeatureList fl = this.getFeatureList();
        if (!(fl.contains("PARALLEL") && fl.contains("ESTO") && fl.contains("ERET") && fl.contains("SIZE"))) {
            throw new ServerException(3);
        }
        logger.debug((Object)"okay, server supports extended, parallel and striped");
    }

    public void setDataChannelAuthentication(DataChannelAuthentication type) throws IOException, ServerException {
        Command cmd = new Command("DCAU", type.toFtpCmdArgument());
        try {
            this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.dataChannelAuthentication = type;
        this.gLocalServer.setDataChannelAuthentication(type);
    }

    public void setLocalNoDataChannelAuthentication() {
        this.gLocalServer.setDataChannelAuthentication(DataChannelAuthentication.NONE);
    }

    public DataChannelAuthentication getDataChannelAuthentication() {
        return this.gSession.dataChannelAuthentication;
    }

    public void setDataChannelProtection(int protection) throws IOException, ServerException {
        String protectionStr = null;
        switch (protection) {
            case 1: {
                protectionStr = "C";
                break;
            }
            case 2: {
                protectionStr = "S";
                break;
            }
            case 3: {
                protectionStr = "E";
                break;
            }
            case 4: {
                protectionStr = "P";
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad protection: " + protection);
            }
        }
        Command cmd = new Command("PROT", protectionStr);
        try {
            this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.gSession.dataChannelProtection = protection;
        this.gLocalServer.setDataChannelProtection(protection);
    }

    public int getDataChannelProtection() {
        return this.gSession.dataChannelProtection;
    }

    public void setAuthorization(Authorization authorization) {
        ((GridFTPControlChannel)this.controlChannel).setAuthorization(authorization);
    }

    public Authorization getAuthorization() {
        return ((GridFTPControlChannel)this.controlChannel).getAuthorization();
    }

    public void get(String remoteFileName, File localFile) throws IOException, ClientException, ServerException {
        if (this.gSession.transferMode == 3) {
            FileRandomIO sink = new FileRandomIO(new RandomAccessFile(localFile, "rw"));
            this.get(remoteFileName, sink, null);
        } else {
            super.get(remoteFileName, localFile);
        }
    }

    public void put(File localFile, String remoteFileName, boolean append) throws IOException, ServerException, ClientException {
        if (this.gSession.transferMode == 3) {
            FileRandomIO source = new FileRandomIO(new RandomAccessFile(localFile, "r"));
            this.put(remoteFileName, source, null, append);
        } else {
            super.put(localFile, remoteFileName, append);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

