/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.ByteArrayOutputStream;
import org.globus.ftp.Buffer;

public class AsciiTranslator {
    public static final byte[] CRLF = new byte[]{13, 10};
    protected boolean possibleBreak = false;
    protected boolean rnSep;
    protected boolean nSep;
    protected byte[] lineSep;
    protected static byte[] systemLineSep = System.getProperty("line.separator").getBytes();

    public AsciiTranslator(boolean rnSep, boolean nSep) {
        this(rnSep, nSep, systemLineSep);
    }

    public AsciiTranslator(boolean rnSep, boolean nSep, byte[] lineSeparator) {
        this.rnSep = rnSep;
        this.nSep = nSep;
        this.lineSep = lineSeparator;
    }

    public Buffer translate(Buffer buffer) {
        byte[] buf = buffer.getBuffer();
        int len = buffer.getLength();
        int bufLastPos = 0;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(len);
        if (this.possibleBreak) {
            if (len > 0 && buf[0] == 10) {
                byteArray.write(this.lineSep, 0, this.lineSep.length);
                bufLastPos = 1;
            } else {
                byteArray.write(13);
            }
            this.possibleBreak = false;
        }
        int i = bufLastPos;
        while (i < len) {
            byte ch = buf[i];
            if (this.rnSep && ch == 13) {
                if (i + 1 == len) {
                    byteArray.write(buf, bufLastPos, i - bufLastPos);
                    bufLastPos = len;
                    this.possibleBreak = true;
                    break;
                }
                if (buf[i + 1] == 10) {
                    byteArray.write(buf, bufLastPos, ++i - 1 - bufLastPos);
                    byteArray.write(this.lineSep, 0, this.lineSep.length);
                    bufLastPos = ++i;
                }
            } else if (this.nSep && ch == 10) {
                byteArray.write(buf, bufLastPos, i - bufLastPos);
                byteArray.write(this.lineSep, 0, this.lineSep.length);
                bufLastPos = i + 1;
            }
            ++i;
        }
        if (bufLastPos < len) {
            byteArray.write(buf, bufLastPos, len - bufLastPos);
        }
        byte[] newBuf = byteArray.toByteArray();
        return new Buffer(newBuf, newBuf.length, buffer.getOffset());
    }
}

