/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannel;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.Task;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;

public class PassiveConnectTask
extends Task {
    protected static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$dc$PassiveConnectTask == null ? (class$org$globus$ftp$dc$PassiveConnectTask = PassiveConnectTask.class$("org.globus.ftp.dc.PassiveConnectTask")) : class$org$globus$ftp$dc$PassiveConnectTask).getName());
    protected static final int STOR = 1;
    protected static final int RETR = 2;
    protected int operation;
    protected ServerSocket myServer;
    protected SocketBox mySocketBox;
    protected DataSink sink;
    protected DataSource source;
    protected BasicServerControlChannel control;
    protected Session session;
    protected DataChannelFactory factory;
    protected TransferContext context;
    static /* synthetic */ Class class$org$globus$ftp$dc$PassiveConnectTask;

    public PassiveConnectTask(ServerSocket myServer, DataSink sink, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        this.sink = sink;
        this.init(myServer, 1, control, session, factory, context);
    }

    public PassiveConnectTask(ServerSocket myServer, DataSource source, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        this.source = source;
        this.init(myServer, 2, control, session, factory, context);
    }

    private void init(ServerSocket myServer, int operation, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        if (session.serverMode != 1 && session.serverMode != 3) {
            throw new IllegalStateException();
        }
        if (myServer == null) {
            throw new IllegalArgumentException("server is nul");
        }
        this.session = session;
        this.myServer = myServer;
        this.operation = operation;
        this.control = control;
        this.factory = factory;
        this.context = context;
    }

    public void execute() {
        block8: {
            try {
                DataChannel dataChannel = null;
                this.mySocketBox = null;
                try {
                    this.mySocketBox = new SocketBox();
                    this.mySocketBox.setSocket(this.openSocket());
                }
                catch (Exception e) {
                    logger.debug((Object)("intercepted: " + e.toString()));
                    FTPServerFacade.exceptionToControlChannel(e, "server.accept() failed", this.control);
                    return;
                }
                try {
                    dataChannel = this.factory.getDataChannel(this.session, this.mySocketBox);
                    if (this.operation == 1) {
                        logger.debug((Object)"starting sink data channel");
                        dataChannel.startTransfer(this.sink, this.control, this.context);
                        break block8;
                    }
                    logger.debug((Object)"starting source data channel");
                    dataChannel.startTransfer(this.source, this.control, this.context);
                }
                catch (Exception e) {
                    logger.debug((Object)("intercepted exception: " + e.toString()));
                    FTPServerFacade.exceptionToControlChannel(e, "startTransfer() failed: ", this.control);
                    if (dataChannel != null) {
                        dataChannel.close();
                    }
                }
            }
            catch (Exception e) {
                FTPServerFacade.cannotPropagateError(e);
            }
        }
    }

    protected Socket openSocket() throws Exception {
        logger.debug((Object)"server.accept()");
        return this.myServer.accept();
    }

    private void close() {
    }

    public void stop() {
        this.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

