/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.extended;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.globus.common.ChainedIOException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.extended.GridFTPInputStream;
import org.globus.ftp.extended.GridFTPOutputStream;
import org.globus.ftp.vanilla.Command;
import org.globus.ftp.vanilla.FTPControlChannel;
import org.globus.ftp.vanilla.Reply;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GridFTPControlChannel
extends FTPControlChannel {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$extended$GridFTPControlChannel == null ? (class$org$globus$ftp$extended$GridFTPControlChannel = GridFTPControlChannel.class$("org.globus.ftp.extended.GridFTPControlChannel")) : class$org$globus$ftp$extended$GridFTPControlChannel).getName());
    protected static final int TIMEOUT = 120000;
    protected GSSCredential credentials = null;
    protected Authorization authorization = HostAuthorization.getInstance();
    static /* synthetic */ Class class$org$globus$ftp$extended$GridFTPControlChannel;

    public GridFTPControlChannel(String host, int port) {
        super(host, port);
    }

    public GridFTPControlChannel(InputStream in, OutputStream out) {
        super(in, out);
    }

    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void authenticate(GSSCredential credential) throws IOException, ServerException {
        this.setCredentials(credential);
        this.write(new Command("AUTH", "GSSAPI"));
        Reply reply0 = null;
        try {
            reply0 = this.read();
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe, "Received faulty reply to AUTH GSSAPI");
        }
        if (!Reply.isPositiveIntermediate(reply0)) {
            this.close();
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(reply0), "Server refused GSSAPI authentication.");
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        GSSContext context = null;
        GridFTPOutputStream gssout = null;
        GridFTPInputStream gssin = null;
        try {
            context = manager.createContext(null, GSSConstants.MECH_OID, credential, 0);
            context.requestCredDeleg(true);
            gssout = new GridFTPOutputStream(this.ftpOut, context);
            gssin = new GridFTPInputStream(this.rawFtpIn, context);
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            while (!context.isEstablished()) {
                outToken = context.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    gssout.writeHandshakeToken(outToken);
                }
                if (context.isEstablished()) continue;
                inToken = gssin.readHandshakeToken();
            }
        }
        catch (GSSException e) {
            throw new ChainedIOException("Authentication failed", e);
        }
        if (this.authorization != null) {
            try {
                this.authorization.authorize(context, this.socket.getInetAddress().getHostAddress());
            }
            catch (AuthorizationException e) {
                throw new ChainedIOException("Authorization failed", e);
            }
        }
        Reply reply1 = null;
        try {
            reply1 = this.read();
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe, "Received faulty reply to authentication");
        }
        if (!Reply.isPositiveCompletion(reply1)) {
            this.close();
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(reply1), "GSSAPI authentication failed.");
        }
        this.setInputStream(gssin);
        this.setOutputStream(gssout);
        this.write(new Command("USER", ":globus-mapping:"));
        Reply reply2 = null;
        try {
            reply2 = this.read();
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe, "Received faulty reply to USER command");
        }
        if (!Reply.isPositiveCompletion(reply2) && !Reply.isPositiveIntermediate(reply2)) {
            this.close();
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(reply2), "User authorization failed.");
        }
        this.write(new Command("PASS", "dummy"));
        Reply reply3 = null;
        try {
            reply3 = this.read();
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe, "Received faulty reply to PASS command");
        }
        if (!Reply.isPositiveCompletion(reply3)) {
            this.close();
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(reply3), "Bad password.");
        }
    }

    protected void setCredentials(GSSCredential credentials) {
        this.credentials = credentials;
    }

    protected GSSCredential getCredentials() {
        return this.credentials;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

