/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.extended;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.HostPort;
import org.globus.ftp.HostPortList;
import org.globus.ftp.Options;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.dc.ActiveConnectTask;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.GridFTPActiveConnectTask;
import org.globus.ftp.dc.GridFTPPassiveConnectTask;
import org.globus.ftp.dc.PassiveConnectTask;
import org.globus.ftp.dc.SecureDataChannelFactory;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.StripeContextManager;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.exception.DataChannelException;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class GridFTPServerFacade
extends FTPServerFacade {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$extended$GridFTPServerFacade == null ? (class$org$globus$ftp$extended$GridFTPServerFacade = GridFTPServerFacade.class$("org.globus.ftp.extended.GridFTPServerFacade")) : class$org$globus$ftp$extended$GridFTPServerFacade).getName());
    protected GridFTPSession gSession = new GridFTPSession();
    protected SocketBox[] socketBoxList = null;
    protected StripeContextManager stripeRetrContextManager = null;
    static /* synthetic */ Class class$org$globus$ftp$extended$GridFTPServerFacade;

    public GridFTPServerFacade() {
        this.session = this.gSession;
        this.localControlChannel = new FTPServerFacade.LocalControlChannel();
        this.dataChannelFactory = new SecureDataChannelFactory();
    }

    public void setCredential(GSSCredential cred) {
        this.gSession.credential = cred;
    }

    public void setDataChannelProtection(int protection) {
        this.gSession.dataChannelProtection = protection;
    }

    public void setDataChannelAuthentication(DataChannelAuthentication authentication) {
        this.gSession.dataChannelAuthentication = authentication;
    }

    public void setOptions(Options opts) {
        if (opts instanceof RetrieveOptions) {
            this.gSession.parallel = ((RetrieveOptions)opts).getStartingParallelism();
            logger.debug((Object)("parallelism set to " + this.gSession.parallel));
        }
    }

    public void setTCPBufferSize(int size) {
        this.gSession.TCPBufferSize = size;
    }

    public void setActive(HostPort hp) throws UnknownHostException, IOException {
        if (!this.gSession.needsGridFTP()) {
            super.setActive(hp);
            return;
        }
        logger.debug((Object)"connecting active socket");
        this.session.serverMode = 2;
        this.socketBoxList = new SocketBox[this.gSession.parallel];
        int i = 0;
        while (i < this.gSession.parallel) {
            this.socketBoxList[i] = new SocketBox();
            this.runTask(this.createActiveConnectTask(hp, this.socketBoxList[i]));
            ++i;
        }
    }

    public void setStripedActive(HostPortList hpl) throws UnknownHostException, IOException {
        if (hpl == null) {
            throw new IllegalArgumentException("null HostPortList");
        }
        int stripes = hpl.size();
        if (stripes < 1) {
            throw new IllegalArgumentException("empty HostPortList");
        }
        this.stripeRetrContextManager = new StripeContextManager(stripes);
        int pathes = this.gSession.parallel;
        this.gSession.serverMode = 4;
        this.socketBoxList = new SocketBox[pathes * stripes];
        int path = 0;
        while (path < pathes) {
            int stripe = 0;
            while (stripe < stripes) {
                int socketIndex = this.getSocketIndex(stripe, pathes, path);
                this.socketBoxList[socketIndex] = new SocketBox();
                logger.debug((Object)"parallel striped active channel connect");
                this.runTask(this.createActiveConnectTask(hpl.get(stripe), this.socketBoxList[socketIndex]));
                ++stripe;
            }
            ++path;
        }
    }

    public HostPortList setStripedPassive() throws IOException {
        return this.setStripedPassive(0, 100);
    }

    public HostPortList setStripedPassive(int port, int queue) throws IOException {
        if (this.server == null) {
            this.server = new ServerSocket(port, queue);
        }
        this.gSession.serverMode = 3;
        this.gSession.serverAddressList = new HostPortList();
        this.gSession.serverAddressList.add(new HostPort(FTPServerFacade.getLocalHostAddress(), this.server.getLocalPort()));
        logger.debug((Object)("started single  striped passive server at port " + this.gSession.serverAddressList.get(0).getPort()));
        return this.gSession.serverAddressList;
    }

    public void store(DataSink sink) {
        try {
            if (!this.gSession.needsGridFTP()) {
                super.store(sink);
                return;
            }
            this.localControlChannel.resetReplyCount();
            if (this.session.transferMode == 3 && this.session.serverMode != 3 && this.session.serverMode != 1) {
                this.exceptionToControlChannel(new DataChannelException(2), "refusing to store with active mode");
            } else {
                TransferContext context = this.createTransferContext();
                int i = 0;
                while (i < this.gSession.parallel) {
                    logger.debug((Object)"creating data connection task");
                    this.runTask(this.createPassiveConnectTask(sink, context));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.exceptionToControlChannel(e, "ocurred during store()");
        }
    }

    public void retrieve(DataSource source) {
        block10: {
            try {
                if (!this.gSession.needsGridFTP()) {
                    super.retrieve(source);
                    return;
                }
                this.localControlChannel.resetReplyCount();
                if (this.session.serverMode == 2) {
                    TransferContext context = this.createTransferContext();
                    if (this.session.transferMode == 3) {
                        ((EBlockParallelTransferContext)context).setEodsTotal(this.gSession.parallel);
                    }
                    int i = 0;
                    while (i < this.gSession.parallel) {
                        this.runTask(this.createActiveStartTransferTask(source, this.socketBoxList[i], context));
                        ++i;
                    }
                    break block10;
                }
                if (this.session.serverMode == 4) {
                    if (this.stripeRetrContextManager == null) {
                        throw new IllegalStateException();
                    }
                    int stripes = this.stripeRetrContextManager.getStripes();
                    int path = 0;
                    while (path < this.gSession.parallel) {
                        int stripe = 0;
                        while (stripe < stripes) {
                            logger.debug((Object)"parallel striped active transfer starts");
                            int index = this.getSocketIndex(stripe, this.gSession.parallel, path);
                            EBlockParallelTransferContext context = this.stripeRetrContextManager.getStripeContext(stripe);
                            context.setEodsTotal(this.gSession.parallel);
                            this.runTask(this.createActiveStartTransferTask(source, this.socketBoxList[index], (TransferContext)context));
                            ++stripe;
                        }
                        ++path;
                    }
                    break block10;
                }
                throw new DataChannelException(2);
            }
            catch (Exception e) {
                this.exceptionToControlChannel(e, "ocurred during retrieve()");
            }
        }
    }

    protected ActiveConnectTask createActiveConnectTask(HostPort hp, SocketBox box) {
        return new GridFTPActiveConnectTask(hp, this.localControlChannel, box, this.gSession);
    }

    protected PassiveConnectTask createPassiveConnectTask(DataSource source, TransferContext context) {
        return new GridFTPPassiveConnectTask(this.server, source, (BasicServerControlChannel)this.localControlChannel, this.gSession, this.dataChannelFactory, context);
    }

    protected PassiveConnectTask createPassiveConnectTask(DataSink sink, TransferContext context) {
        return new GridFTPPassiveConnectTask(this.server, sink, (BasicServerControlChannel)this.localControlChannel, this.gSession, this.dataChannelFactory, context);
    }

    public void abort() throws IOException {
        super.abort();
        if (this.socketBoxList != null) {
            int i = 0;
            while (i < this.socketBoxList.length) {
                Socket mySocket;
                SocketBox myBox = this.socketBoxList[i];
                if (myBox != null && (mySocket = myBox.getSocket()) != null) {
                    mySocket.close();
                }
                ++i;
            }
        }
    }

    public static Socket authenticate(Socket simpleSocket, boolean isClientSocket, GSSCredential credential, int protection, DataChannelAuthentication dcau) throws Exception {
        GSSContext context = null;
        GSSManager manager = ExtendedGSSManager.getInstance();
        context = isClientSocket ? manager.createContext(null, GSSConstants.MECH_OID, credential, 0) : manager.createContext(credential);
        if (protection != 1) {
            ((ExtendedGSSContext)context).setOption(GSSConstants.GSS_MODE, GSIConstants.MODE_SSL);
        }
        context.requestConf(protection == 4);
        logger.debug((Object)"Creating secure socket");
        GssSocketFactory factory = GssSocketFactory.getDefault();
        GssSocket secureSocket = (GssSocket)factory.createSocket(simpleSocket, null, 0, context);
        secureSocket.setUseClientMode(isClientSocket);
        if (dcau == null) {
            secureSocket.setAuthorization(null);
        } else if (dcau == DataChannelAuthentication.SELF) {
            secureSocket.setAuthorization(SelfAuthorization.getInstance());
        } else if (dcau != DataChannelAuthentication.NONE && dcau instanceof DataChannelAuthentication) {
            secureSocket.setAuthorization(new IdentityAuthorization(dcau.toFtpCmdArgument()));
        }
        secureSocket.getOutputStream().flush();
        if (protection == 2) {
            logger.debug((Object)"Data channel protection: on");
            return secureSocket;
        }
        logger.debug((Object)"Data channel protection: off");
        return simpleSocket;
    }

    protected TransferContext createTransferContext() {
        return this.session.transferMode == 3 ? new EBlockParallelTransferContext() : super.createTransferContext();
    }

    private int getSocketIndex(int stripe, int parallelism, int path) {
        int result = stripe * parallelism + path;
        logger.debug((Object)("socket index: " + result));
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

