/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.vanilla.BasicClientControlChannel;
import org.globus.ftp.vanilla.Command;
import org.globus.ftp.vanilla.Flag;
import org.globus.ftp.vanilla.Reply;

public class FTPControlChannel
extends BasicClientControlChannel {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$vanilla$FTPControlChannel == null ? (class$org$globus$ftp$vanilla$FTPControlChannel = FTPControlChannel.class$("org.globus.ftp.vanilla.FTPControlChannel")) : class$org$globus$ftp$vanilla$FTPControlChannel).getName());
    public static final String CRLF = "\r\n";
    private static final int WAIT_FOREVER = -1;
    protected Socket socket;
    protected BufferedReader ftpIn;
    protected InputStream rawFtpIn;
    protected OutputStream ftpOut;
    protected String host;
    protected int port;
    protected boolean hasBeenOpened = false;
    static /* synthetic */ Class class$org$globus$ftp$vanilla$FTPControlChannel;

    public FTPControlChannel(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public FTPControlChannel(InputStream in, OutputStream out) {
        this.setInputStream(in);
        this.setOutputStream(out);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected BufferedReader getBufferedReader() {
        return this.ftpIn;
    }

    protected OutputStream getOutputStream() {
        return this.ftpOut;
    }

    protected void setInputStream(InputStream in) {
        this.rawFtpIn = in;
        this.ftpIn = new BufferedReader(new InputStreamReader(this.rawFtpIn));
    }

    protected void setOutputStream(OutputStream out) {
        this.ftpOut = out;
    }

    public void open() throws IOException, ServerException {
        if (this.hasBeenOpened()) {
            throw new IOException("Attempt to open an already opened connection");
        }
        if (!this.haveStreams()) {
            this.socket = new Socket(this.host, this.port);
            this.setInputStream(this.socket.getInputStream());
            this.setOutputStream(this.socket.getOutputStream());
        }
        this.readInitialReplies();
        this.hasBeenOpened = true;
    }

    protected void readInitialReplies() throws IOException, ServerException {
        Reply reply = null;
        try {
            reply = this.read();
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe, "Received faulty initial reply");
        }
        if (Reply.isPositivePreliminary(reply)) {
            try {
                reply = this.read();
            }
            catch (FTPReplyParseException rpe) {
                throw ServerException.embedFTPReplyParseException(rpe, "Received faulty second reply");
            }
        }
        if (!Reply.isPositiveCompletion(reply)) {
            this.close();
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(reply), "Server refused connection.");
        }
    }

    public void close() throws IOException {
        logger.debug((Object)"ftp socket closed");
        if (this.ftpIn != null) {
            this.ftpIn.close();
        }
        if (this.ftpOut != null) {
            this.ftpOut.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.hasBeenOpened = false;
    }

    public void waitFor(Flag aborted, int ioDelay, int maxWait) throws ServerException, IOException, InterruptedException {
        int i = 0;
        logger.debug((Object)"checking input stream");
        while (!this.ftpIn.ready()) {
            if (aborted.flag) {
                throw new InterruptedException();
            }
            logger.debug((Object)("slept " + i));
            Thread.sleep(ioDelay);
            if (maxWait == -1 || (i += ioDelay) < maxWait) continue;
            logger.debug((Object)"timeout");
            throw new ServerException(4);
        }
        this.ftpIn.mark(2);
        int c = this.ftpIn.read();
        if (c != 0) {
            this.ftpIn.reset();
            return;
        }
        logger.debug((Object)"Server sent \\0; resume wait");
        while (!this.ftpIn.ready()) {
            if (aborted.flag) {
                throw new InterruptedException();
            }
            logger.debug((Object)("sleep " + i));
            Thread.sleep(ioDelay);
            if (maxWait == -1 || (i += ioDelay) < maxWait) continue;
            logger.debug((Object)"timeout");
            throw new ServerException(4);
        }
    }

    public Reply read() throws IOException, FTPReplyParseException {
        Reply reply = new Reply(this.ftpIn);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Control channel received: " + reply));
        }
        return reply;
    }

    public void write(Command cmd) throws IOException, IllegalArgumentException {
        if (cmd == null) {
            throw new IllegalArgumentException("null argument: cmd");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Control channel sending: " + cmd));
        }
        this.writeStr(cmd.toString());
    }

    public Reply exchange(Command cmd) throws IOException, FTPReplyParseException {
        this.write(cmd);
        return this.read();
    }

    public Reply execute(Command cmd) throws IOException, FTPReplyParseException, UnexpectedReplyCodeException {
        Reply reply = this.exchange(cmd);
        if (!Reply.isPositiveCompletion(reply)) {
            throw new UnexpectedReplyCodeException(reply);
        }
        return reply;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeln(String msg) throws IOException {
        this.writeStr(msg + CRLF);
    }

    protected void writeStr(String msg) throws IOException {
        this.ftpOut.write(msg.getBytes());
        this.ftpOut.flush();
    }

    protected boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    protected boolean haveStreams() {
        return this.ftpIn != null && this.ftpOut != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

