/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.util.StringTokenizer;

public class OldCertUtil {
    public static String toGlobusDN(String certDN, boolean skipProxy) {
        StringTokenizer tokens = new StringTokenizer(certDN, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (skipProxy && (token.equalsIgnoreCase("CN=proxy") || token.equalsIgnoreCase("CN=limited proxy"))) continue;
            buf.insert(0, token);
            buf.insert(0, "/");
        }
        return buf.toString();
    }

    public static String getBase(String dn, boolean reverse) {
        int i2;
        if (reverse) {
            int i2;
            int start = dn.length() - 1;
            while (true) {
                i2 = start;
                while (i2 >= 0) {
                    char ch = dn.charAt(i2);
                    if (ch > ' ' && ch != ',') break;
                    --i2;
                }
                if (dn.regionMatches(true, i2 - 7, "cn=proxy", 0, 8)) {
                    start = i2 - 8;
                    continue;
                }
                if (!dn.regionMatches(true, i2 - 15, "cn=limited proxy", 0, 16)) break;
                start = i2 - 16;
            }
            return dn.substring(0, i2 + 1);
        }
        int start = 0;
        int len = dn.length();
        while (true) {
            i2 = start;
            while (i2 < len) {
                char ch = dn.charAt(i2);
                if (ch > ' ' && ch != ',') break;
                ++i2;
            }
            if (dn.regionMatches(true, i2, "cn=proxy", 0, 8)) {
                start = i2 + 8;
                continue;
            }
            if (!dn.regionMatches(true, i2, "cn=limited proxy", 0, 16)) break;
            start = i2 + 16;
        }
        return dn.substring(i2);
    }

    public static int getProxyType(String dn, boolean reverse) {
        String proxyName = OldCertUtil.getProxyName(dn, reverse);
        if (proxyName == null) {
            return -1;
        }
        if (proxyName.equalsIgnoreCase("proxy")) {
            return 10;
        }
        if (proxyName.equalsIgnoreCase("limited proxy")) {
            return 11;
        }
        return -1;
    }

    private static String getProxyName(String dn, boolean reverse) {
        int start = -1;
        int end = -1;
        if (reverse) {
            start = dn.lastIndexOf(44);
            end = dn.length();
        } else {
            start = 0;
            end = dn.indexOf(44);
        }
        if (start < 0 || end < 0) {
            return null;
        }
        if ((start = dn.indexOf(61, start)) < 0 || start > end) {
            return null;
        }
        return dn.substring(++start, end).trim();
    }
}

