/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.io.FilenameFilter;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;

public class TrustedCertificates {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$gsi$TrustedCertificates == null ? (class$org$globus$gsi$TrustedCertificates = TrustedCertificates.class$("org.globus.gsi.TrustedCertificates")) : class$org$globus$gsi$TrustedCertificates).getName());
    public static final CertFilter certFileFilter = new CertFilter();
    private static TrustedCertificates trustedCertificates = null;
    private final Map certLookup;
    private final X509Certificate[] certs;
    static /* synthetic */ Class class$org$globus$gsi$TrustedCertificates;

    private TrustedCertificates(X509Certificate[] certs, Map certLookup) {
        this.certLookup = certLookup;
        this.certs = certs;
    }

    public TrustedCertificates(X509Certificate[] certs) {
        this.certs = certs;
        this.certLookup = new HashMap();
        int i = 0;
        while (i < certs.length) {
            this.certLookup.put(certs[i].getSubjectDN().toString(), certs[i]);
            ++i;
        }
    }

    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    public X509Certificate getCertificate(String subject) {
        if (this.certLookup == null) {
            return null;
        }
        return (X509Certificate)this.certLookup.get(subject);
    }

    public static X509Certificate[] loadCertificates(String locations) {
        if (locations == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        LinkedList certList = new LinkedList();
        File caFile = null;
        while (tokens.hasMoreTokens()) {
            caFile = new File(tokens.nextToken().toString().trim());
            if (caFile.isDirectory()) {
                logger.debug((Object)("Loading certificates from " + caFile.getAbsolutePath() + " directory."));
                String[] caCertFiles = caFile.list(TrustedCertificates.getCertFilter());
                int i = 0;
                while (i < caCertFiles.length) {
                    TrustedCertificates.loadCert(caFile.getPath() + File.separatorChar + caCertFiles[i], certList, null);
                    ++i;
                }
                continue;
            }
            TrustedCertificates.loadCert(caFile.getAbsolutePath(), certList, null);
        }
        if (certList.size() > 0) {
            X509Certificate[] certsArry = new X509Certificate[certList.size()];
            certList.toArray(certsArry);
            return certsArry;
        }
        return null;
    }

    public static TrustedCertificates load(String locations) {
        if (locations == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        LinkedList certList = new LinkedList();
        HashMap certs = new HashMap();
        File caFile = null;
        while (tokens.hasMoreTokens()) {
            caFile = new File(tokens.nextToken().toString().trim());
            if (caFile.isDirectory()) {
                logger.debug((Object)("Loading certificates from " + caFile.getAbsolutePath() + " directory."));
                String[] caCertFiles = caFile.list(TrustedCertificates.getCertFilter());
                int i = 0;
                while (i < caCertFiles.length) {
                    TrustedCertificates.loadCert(caFile.getPath() + File.separatorChar + caCertFiles[i], certList, certs);
                    ++i;
                }
                continue;
            }
            TrustedCertificates.loadCert(caFile.getAbsolutePath(), certList, certs);
        }
        if (certList.size() > 0) {
            X509Certificate[] certsArry = new X509Certificate[certList.size()];
            certList.toArray(certsArry);
            return new TrustedCertificates(certsArry, certs);
        }
        return null;
    }

    public static FilenameFilter getCertFilter() {
        return certFileFilter;
    }

    private static void loadCert(String cert, LinkedList certList, Map certs) {
        logger.debug((Object)("Loading " + cert + " certificate."));
        X509Certificate certificate = null;
        try {
            certificate = CertUtil.loadCertificate(cert);
        }
        catch (Exception e) {
            logger.error((Object)("Certificate " + cert + " failed to load."), (Throwable)e);
            return;
        }
        certList.add(certificate);
        if (certs != null) {
            certs.put(certificate.getSubjectDN().toString(), certificate);
        }
    }

    public static synchronized TrustedCertificates getDefaultTrustedCertificates() {
        if (trustedCertificates == null) {
            trustedCertificates = TrustedCertificates.load(CoGProperties.getDefault().getCaCertLocations());
        }
        return trustedCertificates;
    }

    public static void setDefaultTrustedCertificates(TrustedCertificates trusted) {
        trustedCertificates = trusted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CertFilter
    implements FilenameFilter {
        public boolean accept(File dir, String file) {
            int length = file.length();
            return length > 2 && file.charAt(length - 2) == '.' && file.charAt(length - 1) >= '0' && file.charAt(length - 1) <= '9';
        }
    }
}

