/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.bc;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;

public class BouncyCastleCertProcessingFactory {
    private static BouncyCastleCertProcessingFactory factory;

    protected BouncyCastleCertProcessingFactory() {
    }

    public static synchronized BouncyCastleCertProcessingFactory getDefault() {
        if (factory == null) {
            factory = new BouncyCastleCertProcessingFactory();
        }
        return factory;
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, null, null);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt) throws IOException, GeneralSecurityException {
        return this.createCertificate(certRequestInputStream, cert, privateKey, lifetime, delegationMode, proxyCertInfoExt, null);
    }

    public X509Certificate createCertificate(InputStream certRequestInputStream, X509Certificate cert, PrivateKey privateKey, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt, String cnValue) throws IOException, GeneralSecurityException {
        DERInputStream derin = new DERInputStream(certRequestInputStream);
        DERObject reqInfo = derin.readObject();
        PKCS10CertificationRequest certReq = new PKCS10CertificationRequest((DERConstructedSequence)reqInfo);
        boolean rs = certReq.verify();
        if (!rs) {
            throw new GeneralSecurityException("Certificate request verification failed!");
        }
        return this.createProxyCertificate(cert, privateKey, certReq.getPublicKey(), lifetime, delegationMode, proxyCertInfoExt, cnValue);
    }

    public X509Certificate loadCertificate(InputStream in) throws IOException, GeneralSecurityException {
        DERInputStream derin = new DERInputStream(in);
        DERObject certInfo = derin.readObject();
        ASN1Sequence seq = ASN1Sequence.getInstance(certInfo);
        return new X509CertificateObject(new X509CertificateStructure(seq));
    }

    public GlobusCredential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, null, null);
    }

    public GlobusCredential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt) throws GeneralSecurityException {
        return this.createCredential(certs, privateKey, bits, lifetime, delegationMode, proxyCertInfoExt, null);
    }

    public GlobusCredential createCredential(X509Certificate[] certs, PrivateKey privateKey, int bits, int lifetime, int delegationMode, ProxyCertInfo proxyCertInfoExt, String cnValue) throws GeneralSecurityException {
        KeyPairGenerator keyGen = null;
        keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(bits);
        KeyPair keyPair = keyGen.genKeyPair();
        X509Certificate newCert = this.createProxyCertificate(certs[0], privateKey, keyPair.getPublic(), lifetime, delegationMode, proxyCertInfoExt, cnValue);
        X509Certificate[] newCerts = new X509Certificate[certs.length + 1];
        newCerts[0] = newCert;
        System.arraycopy(certs, 0, newCerts, 1, certs.length);
        return new GlobusCredential(keyPair.getPrivate(), newCerts);
    }

    public byte[] createCertificateRequest(String subject, KeyPair keyPair) throws GeneralSecurityException {
        X509Name name = new X509Name(subject);
        return this.createCertificateRequest(name, "MD5WithRSAEncryption", keyPair);
    }

    public byte[] createCertificateRequest(X509Certificate cert, KeyPair keyPair) throws GeneralSecurityException {
        String issuer = cert.getSubjectDN().getName();
        X509Name subjectDN = new X509Name(issuer + ",CN=proxy");
        String sigAlgName = cert.getSigAlgName();
        return this.createCertificateRequest(subjectDN, sigAlgName, keyPair);
    }

    public byte[] createCertificateRequest(X509Name subjectDN, String sigAlgName, KeyPair keyPair) throws GeneralSecurityException {
        DERConstructedSet attrs = null;
        PKCS10CertificationRequest certReq = null;
        certReq = new PKCS10CertificationRequest(sigAlgName, subjectDN, keyPair.getPublic(), attrs, keyPair.getPrivate());
        return certReq.getEncoded();
    }

    /*
     * Unable to fully structure code
     */
    protected X509Certificate createProxyCertificate(X509Certificate issuerCert, PrivateKey issuerKey, PublicKey publicKey, int lifetime, int proxyType, ProxyCertInfo proxyCertInfo, String cnValue) throws GeneralSecurityException {
        if (proxyType == 2) {
            proxyType = CertUtil.isGsi3Enabled() != false ? 15 : 11;
        } else if (proxyType == 3) {
            proxyType = CertUtil.isGsi3Enabled() != false ? 14 : 10;
        }
        certGen = new X509V3CertificateGenerator();
        serialNum = null;
        delegDN = null;
        if (CertUtil.isGsi3Proxy(proxyType)) {
            rand = new Random();
            delegDN = String.valueOf(Math.abs(rand.nextInt()));
            serialNum = new BigInteger(20, rand);
            if (proxyCertInfo == null) {
                policy = null;
                if (proxyType == 14) {
                    policy = new ProxyPolicy(ProxyPolicy.IMPERSONATION);
                } else if (proxyType == 13) {
                    policy = new ProxyPolicy(ProxyPolicy.INDEPENDENT);
                } else if (proxyType == 15) {
                    policy = new ProxyPolicy(ProxyPolicy.LIMITED);
                } else {
                    if (proxyType == 12) {
                        throw new IllegalArgumentException("Restricted proxy requires ProxyCertInfo");
                    }
                    throw new IllegalArgumentException("Invalid proxyType");
                }
                proxyCertInfo = new ProxyCertInfo(policy);
            }
            certGen.addExtension(ProxyCertInfo.OID, true, (DEREncodable)proxyCertInfo);
            try {
                crt = BouncyCastleUtil.getTBSCertificateStructure(issuerCert);
                extensions = crt.getExtensions();
                if (extensions == null || (ext = extensions.getExtension(X509Extensions.KeyUsage)) == null) ** GOTO lbl53
                bits = (DERBitString)BouncyCastleUtil.getExtensionObject(ext);
                bytes = bits.getBytes();
                if ((bytes[0] & 64) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 64);
                }
                if ((bytes[0] & 4) != 0) {
                    bytes[0] = (byte)(bytes[0] ^ 4);
                }
                bits = new DERBitString(bytes, bits.getPadBits());
                certGen.addExtension(X509Extensions.KeyUsage, ext.isCritical(), (DEREncodable)bits);
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
        } else if (proxyType == 11) {
            delegDN = "limited proxy";
            serialNum = issuerCert.getSerialNumber();
        } else if (proxyType == 10) {
            delegDN = "proxy";
            serialNum = issuerCert.getSerialNumber();
        } else {
            throw new IllegalArgumentException("Unsupported proxyType : " + proxyType);
        }
lbl53:
        // 4 sources

        issuerDN = (X509Name)issuerCert.getSubjectDN();
        issuer = new X509NameHelper(issuerDN);
        subject = new X509NameHelper(issuerDN);
        subject.add(X509Name.CN, cnValue == null ? delegDN : cnValue);
        certGen.setSubjectDN(subject.getAsName());
        certGen.setIssuerDN(issuer.getAsName());
        certGen.setSerialNumber(serialNum);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(issuerCert.getSigAlgName());
        date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -5);
        certGen.setNotBefore(date.getTime());
        if (lifetime <= 0) {
            certGen.setNotAfter(issuerCert.getNotAfter());
        } else {
            date.add(12, 5);
            date.add(13, lifetime);
            certGen.setNotAfter(date.getTime());
        }
        return certGen.generateX509Certificate(issuerKey);
    }
}

