/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.proxy;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.CertificateException;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.sslg.CertVerifyPolicyInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.globus.gsi.CertUtil;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.ptls.PureTLSUtil;
import org.globus.util.log4j.CoGLevel;

public class ProxyPathValidator {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$gsi$proxy$ProxyPathValidator == null ? (class$org$globus$gsi$proxy$ProxyPathValidator = ProxyPathValidator.class$("org.globus.gsi.proxy.ProxyPathValidator")) : class$org$globus$gsi$proxy$ProxyPathValidator).getName());
    private boolean limited = false;
    private X509Certificate identityCert = null;
    private Hashtable proxyPolicyHandlers = null;
    static /* synthetic */ Class class$org$globus$gsi$proxy$ProxyPathValidator;

    public boolean isLimited() {
        return this.limited;
    }

    public X509Certificate getIdentityCertificate() {
        return this.identityCert;
    }

    public String getIdentity() {
        return BouncyCastleUtil.getIdentity(this.identityCert);
    }

    public ProxyPolicyHandler removeProxyPolicyHandler(String id) {
        return id != null && this.proxyPolicyHandlers != null ? (ProxyPolicyHandler)this.proxyPolicyHandlers.remove(id) : null;
    }

    public ProxyPolicyHandler setProxyPolicyHandler(String id, ProxyPolicyHandler handler) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        if (this.proxyPolicyHandlers == null) {
            this.proxyPolicyHandlers = new Hashtable();
        }
        return this.proxyPolicyHandlers.put(id, handler);
    }

    public ProxyPolicyHandler getProxyPolicyHandler(String id) {
        return id != null && this.proxyPolicyHandlers != null ? (ProxyPolicyHandler)this.proxyPolicyHandlers.get(id) : null;
    }

    public void reset() {
        this.limited = false;
        this.identityCert = null;
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts) throws ProxyPathValidatorException {
        if (certPath == null) {
            throw new IllegalArgumentException("certs == null");
        }
        TrustedCertificates trustedCertificates = null;
        Vector validatedChain = null;
        CertVerifyPolicyInt policy = PureTLSUtil.getDefaultCertVerifyPolicy();
        try {
            Vector userCerts = PureTLSUtil.certificateChainToVector(certPath);
            CertContext context = new CertContext();
            if (trustedCerts != null) {
                int i = 0;
                while (i < trustedCerts.length) {
                    context.addRoot(trustedCerts[i].getEncoded());
                    ++i;
                }
                trustedCertificates = new TrustedCertificates(trustedCerts);
            }
            validatedChain = X509Cert.verifyCertChain((CertContext)context, (Vector)userCerts, (CertVerifyPolicyInt)policy);
        }
        catch (CertificateException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        if (validatedChain == null || validatedChain.size() < certPath.length) {
            throw new ProxyPathValidatorException(4, null, "Unknown CA");
        }
        int size = validatedChain.size();
        if (size != certPath.length) {
            X509Certificate[] newCertPath = new X509Certificate[size];
            System.arraycopy(certPath, 0, newCertPath, 0, certPath.length);
            try {
                int i = 0;
                while (i < size - certPath.length) {
                    X509Cert cert = (X509Cert)validatedChain.elementAt(i);
                    ByteArrayInputStream in = new ByteArrayInputStream(cert.getDER());
                    newCertPath[i + certPath.length] = CertUtil.loadCertificate(in);
                    ++i;
                }
            }
            catch (GeneralSecurityException e) {
                throw new ProxyPathValidatorException(-1, (Throwable)e);
            }
            certPath = newCertPath;
        }
        this.validate(certPath, trustedCertificates);
    }

    public void validate(X509Certificate[] certPath) throws ProxyPathValidatorException {
        this.validate(certPath, (TrustedCertificates)null);
    }

    public void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts) throws ProxyPathValidatorException {
        if (certPath == null) {
            throw new IllegalArgumentException("certs == null");
        }
        int proxyDepth = 0;
        try {
            X509Certificate cert = certPath[0];
            TBSCertificateStructure tbsCert = BouncyCastleUtil.getTBSCertificateStructure(cert);
            int certType = BouncyCastleUtil.getCertificateType(tbsCert, trustedCerts);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found cert: " + certType));
            }
            if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
                logger.debug((Object)cert);
            }
            this.checkUnsupportedCriticalExtensions(tbsCert, certType, cert);
            this.checkIdentity(cert, certType);
            if (CertUtil.isProxy(certType)) {
                ++proxyDepth;
            }
            int i = 1;
            while (i < certPath.length) {
                int pathLen;
                X509Certificate issuerCert = certPath[i];
                TBSCertificateStructure issuerTbsCert = BouncyCastleUtil.getTBSCertificateStructure(issuerCert);
                int issuerCertType = BouncyCastleUtil.getCertificateType(issuerTbsCert, trustedCerts);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found cert: " + issuerCertType));
                }
                if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
                    logger.debug((Object)issuerCert);
                }
                if (issuerCertType == 4) {
                    if (CertUtil.isProxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, "CA certificate cannot sign Proxy Certificate");
                    }
                    pathLen = this.getCAPathConstraint(issuerTbsCert);
                    if (pathLen >= 0 && pathLen < Integer.MAX_VALUE && i - proxyDepth - 1 > pathLen) {
                        throw new ProxyPathValidatorException(3, issuerCert, "CA Certificate does not allow path length > " + pathLen + " and path length is " + (i - proxyDepth - 1));
                    }
                } else if (CertUtil.isGsi3Proxy(issuerCertType)) {
                    if (!CertUtil.isGsi3Proxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, "Proxy Certificate can only sign another proxy of the same type");
                    }
                    pathLen = this.getProxyPathConstraint(issuerTbsCert);
                    if (pathLen == 0) {
                        throw new ProxyPathValidatorException(-1, issuerCert, "Proxy Certificate cannot be used to sign another Proxy Certificate.");
                    }
                    if (pathLen < Integer.MAX_VALUE && proxyDepth > pathLen) {
                        throw new ProxyPathValidatorException(3, issuerCert, "Proxy Certificate does not allow path length > " + pathLen + " and path length is " + proxyDepth);
                    }
                    ++proxyDepth;
                } else if (CertUtil.isGsi2Proxy(issuerCertType)) {
                    if (!CertUtil.isGsi2Proxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, "Proxy Certificate can only sign another proxy of the same type");
                    }
                    ++proxyDepth;
                } else if (issuerCertType == 3) {
                    if (!CertUtil.isProxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, "End Entity Certificate can only sign Proxy Certificates");
                    }
                } else {
                    throw new ProxyPathValidatorException(-1, issuerCert, "Unknown cert type: " + issuerCertType);
                }
                if (CertUtil.isProxy(certType)) {
                    if (CertUtil.isGsi3Proxy(certType)) {
                        this.checkProxyConstraints(tbsCert, issuerTbsCert, cert);
                        if (certType == 12) {
                            this.checkRestrictedProxy(tbsCert, certPath, i - 1);
                        }
                    }
                } else {
                    this.checkKeyUsage(issuerTbsCert, certPath, i);
                }
                this.checkUnsupportedCriticalExtensions(issuerTbsCert, issuerCertType, issuerCert);
                this.checkIdentity(issuerCert, issuerCertType);
                cert = issuerCert;
                certType = issuerCertType;
                tbsCert = issuerTbsCert;
                ++i;
            }
        }
        catch (IOException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        catch (ProxyPathValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
    }

    protected void checkIdentity(X509Certificate cert, int certType) {
        if (this.identityCert == null) {
            if (CertUtil.isLimitedProxy(certType)) {
                this.limited = true;
            }
            if (!CertUtil.isImpersonationProxy(certType)) {
                this.identityCert = cert;
            }
        }
    }

    protected void checkRestrictedProxy(TBSCertificateStructure proxy, X509Certificate[] certPath, int index) throws ProxyPathValidatorException, IOException {
        logger.debug((Object)"enter: checkRestrictedProxy");
        ProxyCertInfo info = this.getProxyCertInfo(proxy);
        if (info == null) {
            throw new ProxyPathValidatorException(-1, certPath[index], "Could not retreive ProxyCertInfo extension");
        }
        ProxyPolicy policy = info.getProxyPolicy();
        if (policy == null) {
            throw new ProxyPathValidatorException(-1, certPath[index], "Could not retreive ProxyPolicy from ProxyCertInfo extension");
        }
        String pl = policy.getPolicyLanguage().getId();
        ProxyPolicyHandler handler = this.getProxyPolicyHandler(pl);
        if (handler == null) {
            throw new ProxyPathValidatorException(5, certPath[index], "Unknown policy: " + pl);
        }
        handler.validate(info, certPath, index);
        logger.debug((Object)"exit: checkRestrictedProxy");
    }

    protected void checkKeyUsage(TBSCertificateStructure issuer, X509Certificate[] certPath, int index) throws ProxyPathValidatorException, IOException {
        logger.debug((Object)"enter: checkKeyUsage");
        boolean[] issuerKeyUsage = this.getKeyUsage(issuer);
        if (issuerKeyUsage != null && !issuerKeyUsage[5]) {
            throw new ProxyPathValidatorException(-1, certPath[index], "KeyUsage extension present but keyCertSign bit not asserted");
        }
        logger.debug((Object)"exit: checkKeyUsage");
    }

    protected void checkProxyConstraints(TBSCertificateStructure proxy, TBSCertificateStructure issuer, X509Certificate checkedProxy) throws ProxyPathValidatorException, IOException {
        X509Extension ext;
        DERObjectIdentifier oid;
        Enumeration e;
        logger.debug((Object)"enter: checkProxyConstraints");
        X509Extension proxyKeyUsage = null;
        X509Extensions extensions = proxy.getExtensions();
        if (extensions != null) {
            e = extensions.oids();
            while (e.hasMoreElements()) {
                oid = (DERObjectIdentifier)e.nextElement();
                ext = extensions.getExtension(oid);
                if (oid.equals(X509Extensions.SubjectAlternativeName) || oid.equals(X509Extensions.IssuerAlternativeName)) {
                    throw new ProxyPathValidatorException(1, checkedProxy, "Proxy certificate cannot contain subject or issuer alternative name extension");
                }
                if (oid.equals(X509Extensions.BasicConstraints)) {
                    BasicConstraints basicExt = BouncyCastleUtil.getBasicConstraints(ext);
                    if (!basicExt.isCA()) continue;
                    throw new ProxyPathValidatorException(1, checkedProxy, "Proxy certificate cannot have BasicConstraint CA=true");
                }
                if (!oid.equals(X509Extensions.KeyUsage)) continue;
                proxyKeyUsage = ext;
                boolean[] keyUsage = BouncyCastleUtil.getKeyUsage(ext);
                if (keyUsage[1] || keyUsage[5]) {
                    throw new ProxyPathValidatorException(1, checkedProxy, "The keyCertSign and nonRepudiation bits must not be asserted in Proxy Certificate");
                }
                boolean[] issuerKeyUsage = this.getKeyUsage(issuer);
                if (issuerKeyUsage == null) continue;
                int i = 0;
                while (i < 9) {
                    if (i != 1 && i != 5 && !issuerKeyUsage[i] && keyUsage[i]) {
                        throw new ProxyPathValidatorException(1, checkedProxy, "Bad KeyUsage in Proxy Certificate");
                    }
                    ++i;
                }
            }
        }
        if ((extensions = issuer.getExtensions()) != null) {
            e = extensions.oids();
            while (e.hasMoreElements()) {
                oid = (DERObjectIdentifier)e.nextElement();
                ext = extensions.getExtension(oid);
                if (!oid.equals(X509Extensions.KeyUsage)) continue;
                if (proxyKeyUsage == null) {
                    throw new ProxyPathValidatorException(1, checkedProxy, "KeyUsage extension missing in Proxy Certificate");
                }
                if (!ext.isCritical() || proxyKeyUsage.isCritical()) continue;
                throw new ProxyPathValidatorException(1, checkedProxy, "KeyUsage extension in Proxy Certificate is not critical");
            }
        }
        logger.debug((Object)"exit: checkProxyConstraints");
    }

    protected void checkUnsupportedCriticalExtensions(TBSCertificateStructure crt, int certType, X509Certificate checkedProxy) throws ProxyPathValidatorException {
        logger.debug((Object)"enter: checkUnsupportedCriticalExtensions");
        X509Extensions extensions = crt.getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (!ext.isCritical() || oid.equals(X509Extensions.BasicConstraints) || oid.equals(X509Extensions.KeyUsage) || oid.equals(ProxyCertInfo.OID) && CertUtil.isGsi3Proxy(certType)) continue;
                throw new ProxyPathValidatorException(2, checkedProxy, "Unsuppored critical exception : " + oid.getId());
            }
        }
        logger.debug((Object)"exit: checkUnsupportedCriticalExtensions");
    }

    protected int getProxyPathConstraint(TBSCertificateStructure crt) throws IOException {
        ProxyCertInfo proxyCertExt = this.getProxyCertInfo(crt);
        return proxyCertExt != null ? proxyCertExt.getPathLenConstraint() : -1;
    }

    protected int getCAPathConstraint(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return -1;
        }
        X509Extension ext = extensions.getExtension(X509Extensions.BasicConstraints);
        if (ext != null) {
            BasicConstraints basicExt = BouncyCastleUtil.getBasicConstraints(ext);
            if (basicExt.isCA()) {
                BigInteger pathLen = basicExt.getPathLenConstraint();
                return pathLen == null ? Integer.MAX_VALUE : pathLen.intValue();
            }
            return -1;
        }
        return -1;
    }

    protected ProxyCertInfo getProxyCertInfo(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return null;
        }
        X509Extension ext = extensions.getExtension(ProxyCertInfo.OID);
        return ext != null ? BouncyCastleUtil.getProxyCertInfo(ext) : null;
    }

    protected boolean[] getKeyUsage(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return null;
        }
        X509Extension ext = extensions.getExtension(X509Extensions.KeyUsage);
        return ext != null ? BouncyCastleUtil.getKeyUsage(ext) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

