/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.ptls;

import COM.claymoresystems.cert.X509RSAPrivateKey;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLSessionData;
import cryptix.provider.rsa.RawRSAPrivateKey;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Vector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.gsi.GlobusCredential;
import xjava.security.interfaces.CryptixRSAPrivateKey;

public class PureTLSContext
extends SSLContext {
    static void init() {
    }

    public void setTrustedCertificates(X509Certificate[] certs) throws GeneralSecurityException {
        Vector<byte[]> list = this.getRootList();
        if (list == null) {
            list = new Vector<byte[]>();
            this.setRootList(list);
        }
        int i = 0;
        while (i < certs.length) {
            list.addElement(certs[i].getEncoded());
            ++i;
        }
    }

    public void setCredential(GlobusCredential cred) throws GeneralSecurityException {
        X509Certificate[] certs = cred.getCertificateChain();
        Vector<byte[]> v = new Vector<byte[]>(certs.length);
        int i = certs.length - 1;
        while (i >= 0) {
            v.addElement(certs[i].getEncoded());
            --i;
        }
        this.setCertificateChain(v);
        this.setPrivateKey(PureTLSContext.convertPrivateKey(cred.getPrivateKey()));
        try {
            this.setPublicKeyFromCert(certs[0].getEncoded());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e.getMessage());
        }
    }

    private static PrivateKey convertPrivateKey(PrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            RawRSAPrivateKey ck = new RawRSAPrivateKey(rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getCrtCoefficient());
            return new X509RSAPrivateKey((CryptixRSAPrivateKey)ck);
        }
        throw new IllegalArgumentException();
    }

    protected synchronized SSLSessionData findSession(String key) {
        return null;
    }

    static {
        Security.removeProvider("BC");
        Security.addProvider(new BouncyCastleProvider());
    }
}

