/*
 * Decompiled with CFR 0.152.
 */
package org.globus.security.gridmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.globus.util.QuotedStringTokenizer;

public class GridMap {
    private static final String COMMENT_CHARS = "#";
    protected Map map;
    private File file;
    private long lastModified;

    public void GridMap() {
    }

    public void load(String file) throws IOException {
        this.load(new File(file));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.file = file;
            this.lastModified = file.lastModified();
            this.load(in);
            Object var4_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)in).close();
            return;
        }
        catch (Exception e) {}
    }

    public void refresh() throws IOException {
        if (this.file == null) {
            return;
        }
        if (this.file.lastModified() != this.lastModified) {
            this.load(this.file);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void load(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        HashMap<String, GridMapEntry> localMap = new HashMap<String, GridMapEntry>();
        while ((line = reader.readLine()) != null) {
            void var2_4;
            line = var2_4.trim();
            if (line.length() == 0 || COMMENT_CHARS.indexOf(line.charAt(0)) != -1) continue;
            QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(line);
            String globusID = null;
            if (!tokenizer.hasMoreTokens()) {
                throw new IOException("Globus ID not defined: " + line);
            }
            globusID = tokenizer.nextToken();
            String userIDs = null;
            if (!tokenizer.hasMoreTokens()) {
                throw new IOException("User ID mapping missing: " + line);
            }
            userIDs = tokenizer.nextToken();
            StringTokenizer idTokenizer = new StringTokenizer(userIDs, ",");
            String[] ids = new String[idTokenizer.countTokens()];
            int i = 0;
            while (idTokenizer.hasMoreTokens()) {
                ids[i++] = idTokenizer.nextToken();
            }
            GridMapEntry entry = (GridMapEntry)localMap.get(globusID);
            if (entry == null) {
                entry = new GridMapEntry();
                entry.setGlobusID(globusID);
                entry.setUserIDs(ids);
                localMap.put(globusID, entry);
                continue;
            }
            entry.addUserIDs(ids);
        }
        this.map = localMap;
    }

    public String getUserID(String globusID) {
        String[] ids = this.getUserIDs(globusID);
        if (ids != null && ids.length > 0) {
            return ids[0];
        }
        return null;
    }

    public String[] getUserIDs(String globusID) {
        if (globusID == null) {
            throw new IllegalArgumentException();
        }
        if (this.map == null) {
            String user = System.getProperty("user.name");
            if (user == null) {
                return null;
            }
            String tmpUser = user.toLowerCase();
            if (tmpUser.equals("root") || tmpUser.equals("administrator")) {
                return null;
            }
            return new String[]{user};
        }
        GridMapEntry entry = (GridMapEntry)this.map.get(globusID);
        return entry == null ? null : entry.getUserIDs();
    }

    public boolean checkUser(String globusID, String userID) {
        if (globusID == null || userID == null) {
            throw new IllegalArgumentException();
        }
        if (this.map == null) {
            String user = System.getProperty("user.name");
            if (user == null) {
                return false;
            }
            String tmpUser = user.toLowerCase();
            if (tmpUser.equals("root") || tmpUser.equals("administrator")) {
                return false;
            }
            return user.equalsIgnoreCase(userID);
        }
        GridMapEntry entry = (GridMapEntry)this.map.get(globusID);
        return entry == null ? false : entry.containsUserID(userID);
    }

    public String getGlobusID(String userID) {
        if (userID == null) {
            throw new IllegalArgumentException();
        }
        if (this.map == null) {
            return null;
        }
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry mapEntry = iter.next();
            GridMapEntry entry = (GridMapEntry)mapEntry.getValue();
            if (!entry.containsUserID(userID)) continue;
            return entry.getGlobusID();
        }
        return null;
    }

    public String[] getAllGlobusID(String userID) {
        if (userID == null) {
            throw new IllegalArgumentException();
        }
        if (this.map == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry mapEntry = iter.next();
            GridMapEntry entry = (GridMapEntry)mapEntry.getValue();
            if (!entry.containsUserID(userID)) continue;
            v.add(entry.getGlobusID());
        }
        if (v.size() == 0) {
            return null;
        }
        String[] idS = new String[v.size()];
        int ctr = 0;
        while (ctr < v.size()) {
            idS[ctr] = (String)v.elementAt(ctr);
            ++ctr;
        }
        return idS;
    }

    public void map(String globusID, String userID) {
        GridMapEntry entry;
        if (globusID == null || userID == null) {
            throw new IllegalArgumentException();
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((entry = (GridMapEntry)this.map.get(globusID)) == null) {
            entry = new GridMapEntry();
            entry.setGlobusID(globusID);
            entry.setUserIDs(new String[]{userID});
            this.map.put(globusID, entry);
        } else {
            entry.addUserID(userID);
        }
    }

    private class GridMapEntry {
        String globusID;
        String[] userIDs;

        private GridMapEntry() {
        }

        public String getFirstUserID() {
            return this.userIDs[0];
        }

        public String[] getUserIDs() {
            return this.userIDs;
        }

        public String getGlobusID() {
            return this.globusID;
        }

        public void setGlobusID(String globusID) {
            this.globusID = globusID;
        }

        public void setUserIDs(String[] userIDs) {
            this.userIDs = userIDs;
        }

        public boolean containsUserID(String userID) {
            if (userID == null) {
                return false;
            }
            int i = 0;
            while (i < this.userIDs.length) {
                if (this.userIDs[i].equalsIgnoreCase(userID)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void addUserID(String userID) {
            if (this.containsUserID(userID)) {
                return;
            }
            String[] ids = new String[this.userIDs.length + 1];
            System.arraycopy(this.userIDs, 0, ids, 0, this.userIDs.length);
            ids[this.userIDs.length] = userID;
            this.userIDs = ids;
        }

        public void addUserIDs(String[] userIDs) {
            int i = 0;
            while (i < userIDs.length) {
                this.addUserID(userIDs[i]);
                ++i;
            }
        }
    }
}

