/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.tools.ProxyInit;
import org.globus.util.Util;

class DefaultProxyInit
extends ProxyInit {
    private PrivateKey userKey = null;

    DefaultProxyInit() {
    }

    public void init(String[] args) {
        DefaultProxyInit.verify(args[1], "User key");
        DefaultProxyInit.verify(args[0], "User certificate");
    }

    private static void verify(String file, String msg) {
        File f;
        if (file == null) {
            ProxyInit.error(msg + " not specified.");
        }
        if (!(f = new File(file)).exists() || f.isDirectory()) {
            ProxyInit.error(msg + " not found.");
        }
    }

    public void loadCertificate(String arg) {
        try {
            this.certificate = CertUtil.loadCertificate(arg);
        }
        catch (IOException e) {
            System.err.println("Error: Failed to load cert: " + arg);
            System.exit(-1);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error: Unable to load user certificate: " + e.getMessage());
            System.exit(-1);
        }
    }

    public void loadKey(String arg) {
        try {
            BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(arg);
            if (key.isEncrypted()) {
                String pwd = null;
                pwd = this.quiet ? Util.getInput("Enter GRID pass phrase: ") : Util.getInput("Enter GRID pass phrase for this identity: ");
                if (pwd == null) {
                    System.exit(1);
                }
                key.decrypt(pwd);
            }
            this.userKey = key.getPrivateKey();
        }
        catch (IOException e) {
            System.err.println("Error: Failed to load key: " + arg);
            System.exit(-1);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error: Wrong pass phrase");
            if (this.debug) {
                e.printStackTrace();
            }
            System.exit(-1);
        }
    }

    public void sign() {
        try {
            BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
            this.proxy = factory.createCredential(new X509Certificate[]{this.certificate}, this.userKey, this.bits, this.lifetime, this.proxyType, this.proxyCertInfo);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Failed to create a proxy: " + e.getMessage());
            System.exit(-1);
        }
    }
}

