/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.config;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.globus.common.CoGProperties;
import org.globus.tools.ui.config.BaseModule;
import org.globus.tools.ui.config.CertInfo;
import org.globus.tools.ui.config.CertificateListModel;
import org.globus.tools.ui.config.Configure;

public class ConfigModule2
extends BaseModule
implements ActionListener {
    private JList certList;
    private CertificateListModel certModel;
    private JButton removeBT;
    private JButton addBT;

    public ConfigModule2(CoGProperties props) {
        super(props);
        JLabel label = new JLabel("Configuring Certificate Authorities (CA)");
        label.setFont(this.getFont(this.font, 1));
        label.setForeground(Color.black);
        this.add(label, 1, 1, 1, 1);
        label = new JLabel(" ");
        this.add(label, 1, 2, 1, 1);
        this.certModel = new CertificateListModel();
        this.certModel.setCertList(props.getCaCertLocations());
        this.certList = new JList(this.certModel);
        JScrollPane sp = new JScrollPane(this.certList);
        sp.setPreferredSize(new Dimension(200, 200));
        this.removeBT = new JButton("Remove");
        this.removeBT.addActionListener(this);
        this.addBT = new JButton("Add");
        this.addBT.addActionListener(this);
        this.add(new JLabel("CA (Trusted) Certificates:"), 1, 3, 1, 1);
        this.setFill(2);
        this.setAnchor(11);
        this.add(this.addBT, 2, 4, 1, 1);
        this.add(this.removeBT, 2, 5, 1, 1);
        this.setFill(1);
        this.add(sp, 1, 4, 1, 3);
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        String cmd = e.getActionCommand();
        if (cmd.equals("Add")) {
            this.addCert();
        } else if (cmd.equals("Remove") && (i = this.certList.getSelectedIndex()) != -1) {
            this.certModel.removeCertAt(i);
        }
    }

    private void addCert() {
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("."));
        filechooser.setApproveButtonText("Select");
        filechooser.setDialogTitle("Add CA Certificate");
        if (filechooser.showOpenDialog(this) == 0) {
            File f = filechooser.getSelectedFile();
            try {
                String path = f.getAbsolutePath();
                X509Certificate cert = Configure.loadAndVerifyCertificate(path);
                this.certModel.addCertInfo(new CertInfo(cert, path));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "CA Certificate Error", 0);
            }
        }
    }

    public void saveSettings() {
        this.props.setCaCertLocations(this.certModel.getCertFileList());
    }

    public boolean verifySettings() {
        boolean rs = this.verifyCertificate();
        return rs;
    }

    private boolean verifyCertificate() {
        try {
            X509Certificate cert = (X509Certificate)((Hashtable)this.props).get("internal.usercert");
            this.certModel.verifyUserCertificate(cert);
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "User Certificate Verification Error", 0);
            return false;
        }
    }
}

