/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static Map mapping = new HashMap();
    private ResourceBundle messages = null;

    protected I18n(ResourceBundle messages) {
        this.messages = messages;
    }

    public static synchronized I18n getI18n(String resource) {
        I18n instance = (I18n)mapping.get(resource);
        if (instance == null) {
            instance = new I18n(ResourceBundle.getBundle(resource));
            mapping.put(resource, instance);
        }
        return instance;
    }

    public static synchronized I18n getI18n(String resource, ClassLoader loader) {
        I18n instance = (I18n)mapping.get(resource);
        if (instance == null) {
            instance = new I18n(ResourceBundle.getBundle(resource, Locale.getDefault(), loader));
            mapping.put(resource, instance);
        }
        return instance;
    }

    public String getMessage(String key) throws MissingResourceException {
        return this.messages.getString(key);
    }

    public String getMessage(String key, Object arg) throws MissingResourceException {
        return this.getMessage(key, new Object[]{arg});
    }

    public String getMessage(String key, Object[] vars) throws MissingResourceException {
        return MessageFormat.format(this.messages.getString(key), vars);
    }
}

