/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.metacat.authenticatedqueryservice.impl;

import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.AuthenticatedQueryServicePortType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.GetElementType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.QueryElementType;
import org.ecoinformatics.ecogrid.metacat.authenticatedqueryservice.impl.EcogridQueryToMetacatQueryTransformer;
import org.ecoinformatics.ecogrid.metacat.impl.MetacatResultsetParser;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryTransformer;

public class MetacatAuthenticatedQueryServiceImpl
implements AuthenticatedQueryServicePortType {
    private static Logger logMetacat = Logger.getLogger((Class)MetacatAuthenticatedQueryServiceImpl.class);
    private static String metacatURL = "http://localhost:8080/knb/metacat";

    public ResultsetType query(QueryElementType queryElementType) throws RemoteException {
        logMetacat.warn((Object)"start authenticated query method in grid service");
        ResultsetType resultsetType = new ResultsetType();
        try {
            QueryType queryType = queryElementType.getQuery();
            String string = queryElementType.getSessionId();
            logMetacat.warn((Object)"before transforming query");
            String string2 = EcogridQueryTransformer.toXMLString((QueryType)queryType);
            Reader reader = EcogridQueryToMetacatQueryTransformer.ecogrid2Metacat(string2);
            logMetacat.warn((Object)"after transforming query");
            Metacat metacat = null;
            try {
                metacat = MetacatFactory.createMetacatConnection((String)metacatURL);
                metacat.setSessionId(string);
            }
            catch (Exception exception) {
                logMetacat.error((Object)("could not create metacat instance for URL: " + metacatURL));
            }
            Reader reader2 = metacat.query(reader, "xml");
            String string3 = PropertyService.getProperty((String)"xml.saxparser");
            QueryTypeNamespace[] queryTypeNamespaceArray = queryType.getNamespace();
            String[] stringArray = new String[queryTypeNamespaceArray.length];
            for (int i = 0; i < queryTypeNamespaceArray.length; ++i) {
                stringArray[i] = queryTypeNamespaceArray[i].get_value();
            }
            MetacatResultsetParser metacatResultsetParser = new MetacatResultsetParser(reader2, string3, stringArray);
            resultsetType = metacatResultsetParser.getEcogridResult();
        }
        catch (Exception exception) {
            logMetacat.warn((Object)("The exception is: " + exception.getMessage()));
            throw new RemoteException(exception.getMessage());
        }
        return resultsetType;
    }

    public byte[] get(GetElementType getElementType) throws RemoteException {
        return this.get(getElementType.getIdentifier(), getElementType.getSessionId());
    }

    private byte[] get(String string, String string2) throws RemoteException {
        byte[] byArray;
        if (string == null) {
            throw new RemoteException("Please specify an identifier");
        }
        logMetacat.warn((Object)("in get method.  identifier=" + string));
        if (string2 == null) {
            throw new RemoteException("Please provide an authentication credential (sessionId)");
        }
        logMetacat.warn((Object)("sessionId=" + string2));
        Metacat metacat = null;
        try {
            metacat = MetacatFactory.createMetacatConnection((String)metacatURL);
        }
        catch (Exception exception) {
            logMetacat.error((Object)("could not create metacat instance for URL: " + metacatURL));
        }
        metacat.setSessionId(string2);
        try {
            InputStream inputStream = null;
            boolean bl = false;
            inputStream = bl ? metacat.readInlineData(string) : metacat.read(string);
            int n = inputStream.read();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (n > -1) {
                byteArrayOutputStream.write(n);
                n = inputStream.read();
            }
            byArray = byteArrayOutputStream.toByteArray();
            logMetacat.warn((Object)"after reading doc content");
        }
        catch (Exception exception) {
            logMetacat.warn((Object)("in exception e" + exception.getMessage()));
            throw new RemoteException(exception.getMessage());
        }
        return byArray;
    }

    static {
        try {
            String string = SystemUtil.getServletURL();
            if (string != null && string.length() > 0) {
                metacatURL = string;
            }
        }
        catch (Exception exception) {
            logMetacat.error((Object)("error loading metacat properties: " + exception.getMessage()));
            exception.printStackTrace(System.err);
        }
    }
}

