/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.conf;

import com.ibm.lsid.server.LSIDService;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.conf.LSIDConfigurationException;
import com.ibm.lsid.server.conf.ServiceComponentHandler;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.impl.GatewayAuthority;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ASDLComponentHandler
implements ServiceComponentHandler,
ServiceConfigurationConstants {
    public LSIDService loadComponent(Element compElt, LSIDServiceConfig config) throws LSIDConfigurationException {
        String location = compElt.getAttribute("location");
        if (location == null) {
            throw new LSIDConfigurationException("Must specify location of ASDL document");
        }
        Element envNS = compElt.getOwnerDocument().createElement("nsmappings");
        envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rsdl", "http://www.ibm.com/LSID/Standard/rsdl");
        try {
            GatewayAuthority ga = new GatewayAuthority();
            if (location.equals("file")) {
                String xpathStr = "child::text()";
                String fileStr = XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS).getNodeValue();
                ga.load(new File(fileStr));
            } else if (location.equals("url")) {
                String xpathStr = "child::text()";
                String urlStr = XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS).getNodeValue();
                ga.load(new URL(urlStr));
            } else if (location.equals("java-resource")) {
                String xpathStr = "child::text()";
                String resStr = XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS).getNodeValue();
                InputStream resource = this.getClass().getResourceAsStream(resStr);
                if (resource == null) {
                    throw new LSIDConfigurationException("Could not load resource: " + resStr);
                }
                ga.load(resource);
            } else if (location.equals("inline")) {
                envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:asdl", "http://www.ibm.com/LSID/Standard/ASDL");
                String xpathStr = "asdl:lsid-authority";
                Element asdlElt = (Element)XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS);
                ga.load(asdlElt);
            } else {
                throw new LSIDConfigurationException("Bad ASDL location: " + location);
            }
            return ga;
        }
        catch (Exception e) {
            throw new LSIDConfigurationException(e, "Error handling ASDL component");
        }
    }

    public Vector knownServices() {
        Vector<String> v = new Vector<String>(1);
        v.add("auth");
        return v;
    }
}

