/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.impl.SimpleFANStore;
import com.ibm.lsid.server.metadata.rdf.RDFDocument;
import com.ibm.lsid.server.metadata.rdf.Resource;
import java.io.InputStream;

public class SimpleFANStoreMetadataService
implements LSIDMetadataService {
    public MetadataResponse getMetadata(LSIDRequestContext req, String[] acceptedFormats) throws LSIDServerException {
        RDFDocument rdf = null;
        try {
            rdf = new RDFDocument();
        }
        catch (LSIDServerException e) {
            throw new LSIDServerException((Exception)((Object)e), "Unable to create rdf document for FAN metadata: " + e.getMessage());
        }
        Resource lsidUrn = new Resource(req.getLsid());
        Resource pred = new Resource("urn:lsid:i3c.org:predicates:foreignauthority");
        LSIDAuthority[] auths = SimpleFANStore.lookupFAPs(req.getLsid());
        int i = 0;
        while (i < auths.length) {
            rdf.addTriple(lsidUrn, pred, auths[i].getAuthority());
            ++i;
        }
        InputStream rdfStream = null;
        try {
            rdfStream = rdf.getAsStream();
        }
        catch (LSIDServerException e) {
            throw new LSIDServerException((Exception)((Object)e), "Unable to open rdf stream for FAN metadata:" + e.getMessage());
        }
        return new MetadataResponse((Object)rdfStream, null, "application/xml+rdf");
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
    }
}

