/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.client;

import java.net.URL;
import org.ecoinformatics.ecogrid.stub.EcoGridAuthInterfaceLevelOnePortType;
import org.ecoinformatics.ecogrid.stub.EcogridAuthLoginRequestElementType;
import org.ecoinformatics.ecogrid.stub.service.EcoGridAuthInterfaceLevelOneServiceGridLocator;

public class EcogridAuthClient {
    private URL serviceURL = null;
    private EcoGridAuthInterfaceLevelOnePortType ecogrid = null;

    public static void main(String[] args) {
        String opMode = "";
        String userName = "";
        String passWord = "";
        String sessionId = "";
        String gsh_str = "";
        if (args.length <= 0) {
            EcogridAuthClient.PrintAuthUsage();
            System.exit(0);
        } else {
            opMode = args[0];
            if (opMode.compareToIgnoreCase("login") == 0) {
                if (args.length != 4) {
                    EcogridAuthClient.PrintAuthUsage();
                    System.exit(0);
                }
                userName = args[1];
                passWord = args[2];
                gsh_str = args[3];
            } else if (opMode.compareToIgnoreCase("logout") == 0) {
                if (args.length != 3) {
                    EcogridAuthClient.PrintAuthUsage();
                    System.exit(0);
                }
                sessionId = args[1];
                gsh_str = args[2];
            } else {
                EcogridAuthClient.PrintAuthUsage();
                System.exit(0);
            }
        }
        try {
            URL GSH = new URL(gsh_str);
            EcogridAuthClient client = new EcogridAuthClient(GSH);
            client.createEcoGridAuthLevelOnePortType();
            if (opMode.compareToIgnoreCase("login") == 0) {
                client.login_action(userName, passWord);
            } else if (opMode.compareToIgnoreCase("logout") == 0) {
                client.logout_action(sessionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EcogridAuthClient(URL serviceGSH) {
        this.serviceURL = serviceGSH;
    }

    public String login_action(String UserName, String PassWord) throws Exception {
        EcogridAuthLoginRequestElementType loginReq = new EcogridAuthLoginRequestElementType();
        loginReq.setUserName(UserName);
        loginReq.setPassWd(PassWord);
        String retStr = this.ecogrid.login(loginReq);
        System.out.println(retStr);
        return retStr;
    }

    public void logout_action(String SessionId) throws Exception {
        String retStr = this.ecogrid.logout(SessionId);
    }

    public void createEcoGridAuthLevelOnePortType() throws Exception {
        EcoGridAuthInterfaceLevelOneServiceGridLocator loc = new EcoGridAuthInterfaceLevelOneServiceGridLocator();
        this.ecogrid = loc.getEcoGridAuthInterfaceLevelOnePort(this.serviceURL);
    }

    static void PrintAuthUsage() {
        System.out.println("Usage: java org.ecoinformatics.ecogrid.client.EcogridAuthClient login userName passWord GSH");
        System.out.println("Usage: java org.ecoinformatics.ecogrid.client.EcogridAuthClient logout sessionId GSH");
    }
}

